/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.fetch.ProcessDefinitionGetFormRequest;
import io.camunda.zeebe.client.api.search.response.Form;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.response.FormImpl;
import io.camunda.zeebe.client.protocol.rest.FormItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessDefinitionGetFormRequestImpl
implements ProcessDefinitionGetFormRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long processDefinitionKey;

    public ProcessDefinitionGetFormRequestImpl(HttpClient httpClient, long processDefinitionKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public FinalCommandStep<Form> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<Form> send() {
        HttpZeebeFuture<Form> result = new HttpZeebeFuture<Form>();
        this.httpClient.get(String.format("/process-definitions/%d/form", this.processDefinitionKey), this.httpRequestConfig.build(), FormItem.class, FormImpl::new, result);
        return result;
    }
}

