/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.fetch.ProcessDefinitionGetRequest;
import io.camunda.zeebe.client.api.search.response.ProcessDefinition;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.protocol.rest.ProcessDefinitionItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessDefinitionGetRequestImpl
implements ProcessDefinitionGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long processDefinitionKey;

    public ProcessDefinitionGetRequestImpl(HttpClient httpClient, long processDefinitionKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public FinalCommandStep<ProcessDefinition> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<ProcessDefinition> send() {
        HttpZeebeFuture<ProcessDefinition> result = new HttpZeebeFuture<ProcessDefinition>();
        this.httpClient.get(String.format("/process-definitions/%d", this.processDefinitionKey), this.httpRequestConfig.build(), ProcessDefinitionItem.class, SearchResponseMapper::toProcessDefinitionGetResponse, result);
        return result;
    }
}

