/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.fetch.ProcessInstanceGetRequest;
import io.camunda.zeebe.client.api.search.response.ProcessInstance;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceGetRequestImpl
implements ProcessInstanceGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long processInstanceKey;

    public ProcessInstanceGetRequestImpl(HttpClient httpClient, long processInstanceKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.processInstanceKey = processInstanceKey;
    }

    public ProcessInstanceGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<ProcessInstance> send() {
        HttpZeebeFuture<ProcessInstance> result = new HttpZeebeFuture<ProcessInstance>();
        this.httpClient.get(String.format("/process-instances/%d", this.processInstanceKey), this.httpRequestConfig.build(), ProcessInstanceItem.class, SearchResponseMapper::toProcessInstanceGetResponse, result);
        return result;
    }
}

