/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.fetch.UserTaskGetRequest;
import io.camunda.zeebe.client.api.search.response.UserTask;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.response.UserTaskImpl;
import io.camunda.zeebe.client.protocol.rest.UserTaskItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UserTaskGetRequestImpl
implements UserTaskGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long userTaskKey;

    public UserTaskGetRequestImpl(HttpClient httpClient, long userTaskKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.userTaskKey = userTaskKey;
    }

    public UserTaskGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<UserTask> send() {
        HttpZeebeFuture<UserTask> result = new HttpZeebeFuture<UserTask>();
        this.httpClient.get(String.format("/user-tasks/%d", this.userTaskKey), this.httpRequestConfig.build(), UserTaskItem.class, UserTaskImpl::new, result);
        return result;
    }
}

