/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.fetch;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.fetch.VariableGetRequest;
import io.camunda.zeebe.client.api.search.response.Variable;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.response.VariableImpl;
import io.camunda.zeebe.client.protocol.rest.VariableItem;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class VariableGetRequestImpl
implements VariableGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long variableKey;

    public VariableGetRequestImpl(HttpClient httpClient, long variableKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.variableKey = variableKey;
    }

    public VariableGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<Variable> send() {
        HttpZeebeFuture<Variable> result = new HttpZeebeFuture<Variable>();
        this.httpClient.get(String.format("/variables/%d", this.variableKey), this.httpRequestConfig.build(), VariableItem.class, VariableImpl::new, result);
        return result;
    }
}

