/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.DecisionInstanceFilter;
import io.camunda.zeebe.client.api.search.query.DecisionInstanceQuery;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.response.DecisionInstance;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.sort.DecisionInstanceSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceFilterRequest;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionInstanceQueryImpl
extends TypedSearchRequestPropertyProvider<DecisionInstanceSearchQueryRequest>
implements DecisionInstanceQuery {
    private final DecisionInstanceSearchQueryRequest request = new DecisionInstanceSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionInstanceQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public DecisionInstanceQuery filter(DecisionInstanceFilter value) {
        DecisionInstanceFilterRequest filter = (DecisionInstanceFilterRequest)DecisionInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public DecisionInstanceQuery filter(Consumer<DecisionInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionInstanceFilter(fn));
    }

    @Override
    public DecisionInstanceQuery sort(DecisionInstanceSort value) {
        List sorting = (List)DecisionInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(sorting);
        return this;
    }

    @Override
    public DecisionInstanceQuery sort(Consumer<DecisionInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.decisionInstanceSort(fn));
    }

    @Override
    public DecisionInstanceQuery page(SearchRequestPage value) {
        SearchQueryPageRequest page = (SearchQueryPageRequest)DecisionInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setPage(page);
        return this;
    }

    @Override
    public DecisionInstanceQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionInstanceSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchQueryStep<DecisionInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<DecisionInstance>> send() {
        HttpZeebeFuture<SearchQueryResponse<DecisionInstance>> result = new HttpZeebeFuture<SearchQueryResponse<DecisionInstance>>();
        this.httpClient.post("/decision-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionInstanceSearchQueryResponse.class, resp -> SearchResponseMapper.toDecisionInstanceSearchResponse(resp, this.jsonMapper), result);
        return result;
    }
}

