/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.ProcessDefinitionFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.ProcessDefinitionQuery;
import io.camunda.zeebe.client.api.search.response.ProcessDefinition;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.sort.ProcessDefinitionSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.protocol.rest.ProcessDefinitionFilterRequest;
import io.camunda.zeebe.client.protocol.rest.ProcessDefinitionSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.ProcessDefinitionSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessDefinitionQueryImpl
extends TypedSearchRequestPropertyProvider<ProcessDefinitionSearchQueryRequest>
implements ProcessDefinitionQuery {
    private final ProcessDefinitionSearchQueryRequest request = new ProcessDefinitionSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessDefinitionQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<ProcessDefinition> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<ProcessDefinition>> send() {
        HttpZeebeFuture<SearchQueryResponse<ProcessDefinition>> result = new HttpZeebeFuture<SearchQueryResponse<ProcessDefinition>>();
        this.httpClient.post("/process-definitions/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ProcessDefinitionSearchQueryResponse.class, SearchResponseMapper::toProcessDefinitionSearchResponse, result);
        return result;
    }

    @Override
    public ProcessDefinitionQuery filter(ProcessDefinitionFilter value) {
        ProcessDefinitionFilterRequest filter = (ProcessDefinitionFilterRequest)ProcessDefinitionQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public ProcessDefinitionQuery filter(Consumer<ProcessDefinitionFilter> fn) {
        return this.filter(SearchRequestBuilders.processDefinitionFilter(fn));
    }

    @Override
    public ProcessDefinitionQuery sort(ProcessDefinitionSort value) {
        List sorting = (List)ProcessDefinitionQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(sorting);
        return this;
    }

    @Override
    public ProcessDefinitionQuery sort(Consumer<ProcessDefinitionSort> fn) {
        return this.sort(SearchRequestBuilders.processDefinitionSort(fn));
    }

    @Override
    public ProcessDefinitionQuery page(SearchRequestPage value) {
        SearchQueryPageRequest page = (SearchQueryPageRequest)ProcessDefinitionQueryImpl.provideSearchRequestProperty(value);
        this.request.setPage(page);
        return this;
    }

    @Override
    public ProcessDefinitionQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected ProcessDefinitionSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

