/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.UserTaskVariableFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.UserTaskVariableQuery;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.response.Variable;
import io.camunda.zeebe.client.api.search.sort.VariableSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchRequestPageImpl;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.impl.search.sort.VariableSortImpl;
import io.camunda.zeebe.client.protocol.rest.SearchQuerySortRequest;
import io.camunda.zeebe.client.protocol.rest.UserTaskVariableSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.VariableSearchQueryResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UserTaskVariableQueryImpl
extends TypedSearchRequestPropertyProvider<UserTaskVariableSearchQueryRequest>
implements UserTaskVariableQuery {
    private final UserTaskVariableSearchQueryRequest request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;
    private final long userTaskKey;

    public UserTaskVariableQueryImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskVariableSearchQueryRequest();
    }

    @Override
    public FinalSearchQueryStep<Variable> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<Variable>> send() {
        HttpZeebeFuture<SearchQueryResponse<Variable>> result = new HttpZeebeFuture<SearchQueryResponse<Variable>>();
        this.httpClient.post(String.format("/user-tasks/%d/variables", this.userTaskKey), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), VariableSearchQueryResponse.class, SearchResponseMapper::toVariableSearchResponse, result);
        return result;
    }

    @Override
    public UserTaskVariableQuery filter(UserTaskVariableFilter value) {
        return null;
    }

    @Override
    public UserTaskVariableQuery filter(Consumer<UserTaskVariableFilter> fn) {
        return null;
    }

    @Override
    public UserTaskVariableQuery sort(VariableSort value) {
        VariableSortImpl sorting = (VariableSortImpl)value;
        this.request.setSort((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty());
        return this;
    }

    @Override
    public UserTaskVariableQuery sort(Consumer<VariableSort> fn) {
        return this.sort(SearchRequestBuilders.variableSort(fn));
    }

    @Override
    public UserTaskVariableQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public UserTaskVariableQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected UserTaskVariableSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

