/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.VariableFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.VariableQuery;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.response.Variable;
import io.camunda.zeebe.client.api.search.sort.VariableSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchRequestPageImpl;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.impl.search.sort.VariableSortImpl;
import io.camunda.zeebe.client.protocol.rest.SearchQuerySortRequest;
import io.camunda.zeebe.client.protocol.rest.VariableFilterRequest;
import io.camunda.zeebe.client.protocol.rest.VariableSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.VariableSearchQueryResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class VariableQueryImpl
extends TypedSearchRequestPropertyProvider<VariableSearchQueryRequest>
implements VariableQuery {
    private final VariableSearchQueryRequest request = new VariableSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public VariableQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<Variable> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<Variable>> send() {
        HttpZeebeFuture<SearchQueryResponse<Variable>> result = new HttpZeebeFuture<SearchQueryResponse<Variable>>();
        this.httpClient.post("/variables/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), VariableSearchQueryResponse.class, SearchResponseMapper::toVariableSearchResponse, result);
        return result;
    }

    @Override
    public VariableQuery filter(VariableFilter value) {
        VariableFilterRequest filter = (VariableFilterRequest)VariableQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public VariableQuery filter(Consumer<VariableFilter> fn) {
        return this.filter(SearchRequestBuilders.variableFilter(fn));
    }

    @Override
    public VariableQuery sort(VariableSort value) {
        VariableSortImpl sorting = (VariableSortImpl)value;
        this.request.setSort((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty());
        return this;
    }

    @Override
    public VariableQuery sort(Consumer<VariableSort> fn) {
        return this.sort(SearchRequestBuilders.variableSort(fn));
    }

    @Override
    public VariableQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public VariableQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected VariableSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

