/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.EvaluatedDecisionInput;
import io.camunda.zeebe.client.api.response.MatchedDecisionRule;
import io.camunda.zeebe.client.api.search.response.DecisionDefinitionType;
import io.camunda.zeebe.client.api.search.response.DecisionInstance;
import io.camunda.zeebe.client.api.search.response.DecisionInstanceState;
import io.camunda.zeebe.client.impl.response.EvaluatedDecisionInputImpl;
import io.camunda.zeebe.client.impl.response.MatchedDecisionRuleImpl;
import io.camunda.zeebe.client.protocol.rest.DecisionDefinitionTypeEnum;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceGetQueryResponse;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceItem;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.client.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.zeebe.client.protocol.rest.MatchedDecisionRuleItem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DecisionInstanceImpl
implements DecisionInstance {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final long decisionInstanceKey;
    private final String decisionInstanceId;
    private final DecisionInstanceState state;
    private final String evaluationDate;
    private final String evaluationFailure;
    private final Long processDefinitionKey;
    private final Long processInstanceKey;
    private final long decisionKey;
    private final String decisionDefinitionId;
    private final String decisionDefinitionName;
    private final int decisionDefinitionVersion;
    private final DecisionDefinitionType decisionDefinitionType;
    private final String tenantId;
    private final List<EvaluatedDecisionInput> evaluatedInputs;
    private final List<MatchedDecisionRule> matchedRules;

    public DecisionInstanceImpl(DecisionInstanceItem item, JsonMapper jsonMapper) {
        this(jsonMapper, item.getDecisionInstanceKey(), item.getDecisionInstanceId(), DecisionInstanceImpl.toDecisionInstanceState(item.getState()), item.getEvaluationDate(), item.getEvaluationFailure(), item.getProcessDefinitionKey(), item.getProcessInstanceKey(), item.getDecisionDefinitionKey(), item.getDecisionDefinitionId(), item.getDecisionDefinitionName(), item.getDecisionDefinitionVersion(), DecisionInstanceImpl.toDecisionDefinitionType(item.getDecisionDefinitionType()), item.getTenantId(), null, null);
    }

    public DecisionInstanceImpl(DecisionInstanceGetQueryResponse item, JsonMapper jsonMapper) {
        this(jsonMapper, item.getDecisionInstanceKey(), item.getDecisionInstanceId(), DecisionInstanceImpl.toDecisionInstanceState(item.getState()), item.getEvaluationDate(), item.getEvaluationFailure(), item.getProcessDefinitionKey(), item.getProcessInstanceKey(), item.getDecisionDefinitionKey(), item.getDecisionDefinitionId(), item.getDecisionDefinitionName(), item.getDecisionDefinitionVersion(), DecisionInstanceImpl.toDecisionDefinitionType(item.getDecisionDefinitionType()), item.getTenantId(), item.getEvaluatedInputs().stream().map(input -> new EvaluatedDecisionInputImpl((EvaluatedDecisionInputItem)input, jsonMapper)).collect(Collectors.toList()), item.getMatchedRules().stream().map(rule -> new MatchedDecisionRuleImpl((MatchedDecisionRuleItem)rule, jsonMapper)).collect(Collectors.toList()));
    }

    public DecisionInstanceImpl(JsonMapper jsonMapper, long decisionInstanceKey, String decisionInstanceId, DecisionInstanceState state, String evaluationDate, String evaluationFailure, Long processDefinitionKey, Long processInstanceKey, long decisionKey, String decisionDefinitionId, String decisionDefinitionName, int decisionDefinitionVersion, DecisionDefinitionType decisionDefinitionType, String tenantId, List<EvaluatedDecisionInput> evaluatedInputs, List<MatchedDecisionRule> matchedRules) {
        this.jsonMapper = jsonMapper;
        this.decisionInstanceKey = decisionInstanceKey;
        this.decisionInstanceId = decisionInstanceId;
        this.state = state;
        this.evaluationDate = evaluationDate;
        this.evaluationFailure = evaluationFailure;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.decisionKey = decisionKey;
        this.decisionDefinitionId = decisionDefinitionId;
        this.decisionDefinitionName = decisionDefinitionName;
        this.decisionDefinitionVersion = decisionDefinitionVersion;
        this.decisionDefinitionType = decisionDefinitionType;
        this.tenantId = tenantId;
        this.evaluatedInputs = evaluatedInputs;
        this.matchedRules = matchedRules;
    }

    private static DecisionDefinitionType toDecisionDefinitionType(DecisionDefinitionTypeEnum decisionDefinitionType) {
        if (decisionDefinitionType == null) {
            return null;
        }
        switch (decisionDefinitionType) {
            case DECISION_TABLE: {
                return DecisionDefinitionType.DECISION_TABLE;
            }
            case LITERAL_EXPRESSION: {
                return DecisionDefinitionType.LITERAL_EXPRESSION;
            }
            case UNSPECIFIED: {
                return DecisionDefinitionType.UNSPECIFIED;
            }
        }
        return DecisionDefinitionType.UNKNOWN;
    }

    private static DecisionInstanceState toDecisionInstanceState(DecisionInstanceStateEnum decisionInstanceState) {
        if (decisionInstanceState == null) {
            return null;
        }
        switch (decisionInstanceState) {
            case EVALUATED: {
                return DecisionInstanceState.EVALUATED;
            }
            case FAILED: {
                return DecisionInstanceState.FAILED;
            }
            case UNSPECIFIED: {
                return DecisionInstanceState.UNSPECIFIED;
            }
        }
        return DecisionInstanceState.UNKNOWN;
    }

    @Override
    public long getDecisionInstanceKey() {
        return this.decisionInstanceKey;
    }

    @Override
    public String getDecisionInstanceId() {
        return this.decisionInstanceId;
    }

    @Override
    public DecisionInstanceState getState() {
        return this.state;
    }

    @Override
    public String getEvaluationDate() {
        return this.evaluationDate;
    }

    @Override
    public String getEvaluationFailure() {
        return this.evaluationFailure;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public long getDecisionDefinitionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    @Override
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    @Override
    public int getDecisionDefinitionVersion() {
        return this.decisionDefinitionVersion;
    }

    @Override
    public DecisionDefinitionType getDecisionDefinitionType() {
        return this.decisionDefinitionType;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<EvaluatedDecisionInput> getEvaluatedInputs() {
        return this.evaluatedInputs;
    }

    @Override
    public List<MatchedDecisionRule> getMatchedRules() {
        return this.matchedRules;
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.decisionInstanceKey, this.decisionInstanceId, this.state, this.evaluationDate, this.evaluationFailure, this.processDefinitionKey, this.processInstanceKey, this.decisionKey, this.decisionDefinitionId, this.decisionDefinitionName, this.decisionDefinitionVersion, this.decisionDefinitionType, this.tenantId, this.evaluatedInputs, this.matchedRules});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionInstanceImpl that = (DecisionInstanceImpl)o;
        return this.decisionInstanceKey == that.decisionInstanceKey && this.decisionKey == that.decisionKey && this.decisionDefinitionVersion == that.decisionDefinitionVersion && this.state == that.state && Objects.equals(this.decisionInstanceId, that.decisionInstanceId) && Objects.equals(this.evaluationDate, that.evaluationDate) && Objects.equals(this.evaluationFailure, that.evaluationFailure) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.decisionDefinitionId, that.decisionDefinitionId) && Objects.equals(this.decisionDefinitionName, that.decisionDefinitionName) && this.decisionDefinitionType == that.decisionDefinitionType && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.evaluatedInputs, that.evaluatedInputs) && Objects.equals(this.matchedRules, that.matchedRules);
    }
}

