/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.response;

import io.camunda.zeebe.client.api.search.response.Incident;
import io.camunda.zeebe.client.protocol.rest.IncidentItem;
import java.util.Objects;

public class IncidentImpl
implements Incident {
    private final Long incidentKey;
    private final Long processDefinitionKey;
    private final String processDefinitionId;
    private final Long processInstanceKey;
    private final IncidentItem.ErrorTypeEnum errorType;
    private final String errorMessage;
    private final String flowNodeId;
    private final Long flowNodeInstanceKey;
    private final String creationTime;
    private final IncidentItem.StateEnum state;
    private final Long jobKey;
    private final String treePath;
    private final String tenantId;

    public IncidentImpl(IncidentItem item) {
        this.incidentKey = item.getIncidentKey();
        this.processDefinitionKey = item.getProcessDefinitionKey();
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processInstanceKey = item.getProcessInstanceKey();
        this.errorType = item.getErrorType();
        this.errorMessage = item.getErrorMessage();
        this.flowNodeId = item.getFlowNodeId();
        this.flowNodeInstanceKey = item.getFlowNodeInstanceKey();
        this.creationTime = item.getCreationTime();
        this.state = item.getState();
        this.jobKey = item.getJobKey();
        this.treePath = item.getTreePath();
        this.tenantId = item.getTenantId();
    }

    @Override
    public Long getIncidentKey() {
        return this.incidentKey;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    @Override
    public Long getFlowNodeInstanceKey() {
        return this.flowNodeInstanceKey;
    }

    @Override
    public String getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getState() {
        return this.state.getValue();
    }

    @Override
    public Long getJobKey() {
        return this.jobKey;
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getErrorType() {
        return this.errorType.getValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.incidentKey, this.processDefinitionKey, this.processDefinitionId, this.processInstanceKey, this.errorType, this.errorMessage, this.flowNodeId, this.flowNodeInstanceKey, this.creationTime, this.state, this.jobKey, this.treePath, this.tenantId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentImpl incident = (IncidentImpl)o;
        return Objects.equals(this.incidentKey, incident.incidentKey) && Objects.equals(this.processDefinitionKey, incident.processDefinitionKey) && Objects.equals(this.processDefinitionId, incident.processDefinitionId) && Objects.equals(this.processInstanceKey, incident.processInstanceKey) && this.errorType == incident.errorType && Objects.equals(this.errorMessage, incident.errorMessage) && Objects.equals(this.flowNodeId, incident.flowNodeId) && Objects.equals(this.flowNodeInstanceKey, incident.flowNodeInstanceKey) && Objects.equals(this.creationTime, incident.creationTime) && this.state == incident.state && Objects.equals(this.jobKey, incident.jobKey) && Objects.equals(this.treePath, incident.treePath) && Objects.equals(this.tenantId, incident.tenantId);
    }
}

