/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.response;

import io.camunda.zeebe.client.api.search.response.ProcessInstance;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceItem;
import java.util.Optional;

public class ProcessInstanceImpl
implements ProcessInstance {
    private final Long processInstanceKey;
    private final String processDefinitionId;
    private final String processDefinitionName;
    private final Integer processDefinitionVersion;
    private final String processDefinitionVersionTag;
    private final Long processDefinitionKey;
    private final Long parentProcessInstanceKey;
    private final Long parentFlowNodeInstanceKey;
    private final String treePath;
    private final String startDate;
    private final String endDate;
    private final String state;
    private final Boolean hasIncident;
    private final String tenantId;

    public ProcessInstanceImpl(ProcessInstanceItem item) {
        this.processInstanceKey = item.getProcessInstanceKey();
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processDefinitionName = item.getProcessDefinitionName();
        this.processDefinitionVersion = item.getProcessDefinitionVersion();
        this.processDefinitionVersionTag = item.getProcessDefinitionVersionTag();
        this.processDefinitionKey = item.getProcessDefinitionKey();
        this.parentProcessInstanceKey = item.getParentProcessInstanceKey();
        this.parentFlowNodeInstanceKey = item.getParentFlowNodeInstanceKey();
        this.treePath = item.getTreePath();
        this.startDate = item.getStartDate();
        this.endDate = item.getEndDate();
        this.state = Optional.ofNullable(item.getState()).map(Enum::toString).orElse(null);
        this.hasIncident = item.getHasIncident();
        this.tenantId = item.getTenantId();
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public String getProcessDefinitionVersionTag() {
        return this.processDefinitionVersionTag;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKey;
    }

    @Override
    public Long getParentFlowNodeInstanceKey() {
        return this.parentFlowNodeInstanceKey;
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public String getStartDate() {
        return this.startDate;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public Boolean getHasIncident() {
        return this.hasIncident;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }
}

