/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.OwnerTypeEnum;
import io.camunda.zeebe.client.protocol.rest.PermissionDTO;
import io.camunda.zeebe.client.protocol.rest.ResourceTypeEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"ownerKey", "ownerType", "resourceType", "permissions"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthorizationResponse {
    public static final String JSON_PROPERTY_OWNER_KEY = "ownerKey";
    private Long ownerKey;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    private ResourceTypeEnum resourceType;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<PermissionDTO> permissions = new ArrayList<PermissionDTO>();

    public AuthorizationResponse ownerKey(Long ownerKey) {
        this.ownerKey = ownerKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOwnerKey() {
        return this.ownerKey;
    }

    @JsonProperty(value="ownerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerKey(Long ownerKey) {
        this.ownerKey = ownerKey;
    }

    public AuthorizationResponse ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nullable
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public AuthorizationResponse resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public AuthorizationResponse permissions(List<PermissionDTO> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AuthorizationResponse addPermissionsItem(PermissionDTO permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionDTO>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PermissionDTO> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(List<PermissionDTO> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)o;
        return Objects.equals(this.ownerKey, authorizationResponse.ownerKey) && Objects.equals((Object)this.ownerType, (Object)authorizationResponse.ownerType) && Objects.equals((Object)this.resourceType, (Object)authorizationResponse.resourceType) && Objects.equals(this.permissions, authorizationResponse.permissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ownerKey, this.ownerType, this.resourceType, this.permissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationResponse {\n");
        sb.append("    ownerKey: ").append(this.toIndentedString(this.ownerKey)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOwnerKey() != null) {
            try {
                joiner.add(String.format("%sownerKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOwnerKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOwnerType() != null) {
            try {
                joiner.add(String.format("%sownerType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOwnerType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceType() != null) {
            try {
                joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPermissions() != null) {
            for (int i = 0; i < this.getPermissions().size(); ++i) {
                if (this.getPermissions().get(i) == null) continue;
                joiner.add(this.getPermissions().get(i).toUrlQueryString(String.format("%spermissions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

