/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.zeebe.client.protocol.rest.PermissionTypeEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"permissionType", "resourceIds"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PermissionDTO {
    public static final String JSON_PROPERTY_PERMISSION_TYPE = "permissionType";
    private PermissionTypeEnum permissionType;
    public static final String JSON_PROPERTY_RESOURCE_IDS = "resourceIds";
    private Set<String> resourceIds = new LinkedHashSet<String>();

    public PermissionDTO permissionType(PermissionTypeEnum permissionType) {
        this.permissionType = permissionType;
        return this;
    }

    @Nullable
    @JsonProperty(value="permissionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionTypeEnum getPermissionType() {
        return this.permissionType;
    }

    @JsonProperty(value="permissionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissionType(PermissionTypeEnum permissionType) {
        this.permissionType = permissionType;
    }

    public PermissionDTO resourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public PermissionDTO addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new LinkedHashSet<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="resourceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionDTO permissionDTO = (PermissionDTO)o;
        return Objects.equals((Object)this.permissionType, (Object)permissionDTO.permissionType) && Objects.equals(this.resourceIds, permissionDTO.resourceIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permissionType, this.resourceIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionDTO {\n");
        sb.append("    permissionType: ").append(this.toIndentedString((Object)this.permissionType)).append("\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPermissionType() != null) {
            try {
                joiner.add(String.format("%spermissionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getPermissionType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResourceIds() != null) {
            int i = 0;
            for (String _item : this.getResourceIds()) {
                try {
                    joiner.add(String.format("%sresourceIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return joiner.toString();
    }
}

