/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"key", "name", "assignedMemberKeys"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RoleItem {
    public static final String JSON_PROPERTY_KEY = "key";
    private Long key;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ASSIGNED_MEMBER_KEYS = "assignedMemberKeys";
    private List<Long> assignedMemberKeys = new ArrayList<Long>();

    public RoleItem key(Long key) {
        this.key = key;
        return this;
    }

    @Nullable
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKey(Long key) {
        this.key = key;
    }

    public RoleItem name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public RoleItem assignedMemberKeys(List<Long> assignedMemberKeys) {
        this.assignedMemberKeys = assignedMemberKeys;
        return this;
    }

    public RoleItem addAssignedMemberKeysItem(Long assignedMemberKeysItem) {
        if (this.assignedMemberKeys == null) {
            this.assignedMemberKeys = new ArrayList<Long>();
        }
        this.assignedMemberKeys.add(assignedMemberKeysItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assignedMemberKeys")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getAssignedMemberKeys() {
        return this.assignedMemberKeys;
    }

    @JsonProperty(value="assignedMemberKeys")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignedMemberKeys(List<Long> assignedMemberKeys) {
        this.assignedMemberKeys = assignedMemberKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleItem roleItem = (RoleItem)o;
        return Objects.equals(this.key, roleItem.key) && Objects.equals(this.name, roleItem.name) && Objects.equals(this.assignedMemberKeys, roleItem.assignedMemberKeys);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.assignedMemberKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleItem {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    assignedMemberKeys: ").append(this.toIndentedString(this.assignedMemberKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getKey() != null) {
            try {
                joiner.add(String.format("%skey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAssignedMemberKeys() != null) {
            for (int i = 0; i < this.getAssignedMemberKeys().size(); ++i) {
                try {
                    joiner.add(String.format("%sassignedMemberKeys%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getAssignedMemberKeys().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

