/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.IntegerFilterProperty;
import io.camunda.zeebe.client.protocol.rest.StringFilterProperty;
import io.camunda.zeebe.client.protocol.rest.UserTaskVariableFilterRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"userTaskKey", "state", "assignee", "priority", "elementId", "candidateGroup", "candidateUser", "processDefinitionKey", "processInstanceKey", "tenantId", "processDefinitionId", "elementInstanceKey", "variables"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserTaskFilterRequest {
    public static final String JSON_PROPERTY_USER_TASK_KEY = "userTaskKey";
    private Long userTaskKey;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
    private StringFilterProperty assignee;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private IntegerFilterProperty priority;
    public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
    private String elementId;
    public static final String JSON_PROPERTY_CANDIDATE_GROUP = "candidateGroup";
    private StringFilterProperty candidateGroup;
    public static final String JSON_PROPERTY_CANDIDATE_USER = "candidateUser";
    private StringFilterProperty candidateUser;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private Long processDefinitionKey;
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
    private Long processInstanceKey;
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private String processDefinitionId;
    public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
    private Long elementInstanceKey;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<UserTaskVariableFilterRequest> variables = new ArrayList<UserTaskVariableFilterRequest>();

    public UserTaskFilterRequest userTaskKey(Long userTaskKey) {
        this.userTaskKey = userTaskKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="userTaskKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUserTaskKey() {
        return this.userTaskKey;
    }

    @JsonProperty(value="userTaskKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserTaskKey(Long userTaskKey) {
        this.userTaskKey = userTaskKey;
    }

    public UserTaskFilterRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public UserTaskFilterRequest assignee(StringFilterProperty assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StringFilterProperty getAssignee() {
        return this.assignee;
    }

    @JsonProperty(value="assignee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignee(StringFilterProperty assignee) {
        this.assignee = assignee;
    }

    public UserTaskFilterRequest priority(IntegerFilterProperty priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IntegerFilterProperty getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(IntegerFilterProperty priority) {
        this.priority = priority;
    }

    public UserTaskFilterRequest elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    @Nullable
    @JsonProperty(value="elementId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getElementId() {
        return this.elementId;
    }

    @JsonProperty(value="elementId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public UserTaskFilterRequest candidateGroup(StringFilterProperty candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    @Nullable
    @JsonProperty(value="candidateGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StringFilterProperty getCandidateGroup() {
        return this.candidateGroup;
    }

    @JsonProperty(value="candidateGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCandidateGroup(StringFilterProperty candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    public UserTaskFilterRequest candidateUser(StringFilterProperty candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    @Nullable
    @JsonProperty(value="candidateUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StringFilterProperty getCandidateUser() {
        return this.candidateUser;
    }

    @JsonProperty(value="candidateUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCandidateUser(StringFilterProperty candidateUser) {
        this.candidateUser = candidateUser;
    }

    public UserTaskFilterRequest processDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @JsonProperty(value="processDefinitionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public UserTaskFilterRequest processInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public UserTaskFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public UserTaskFilterRequest processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @JsonProperty(value="processDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public UserTaskFilterRequest elementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="elementInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @JsonProperty(value="elementInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setElementInstanceKey(Long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public UserTaskFilterRequest variables(List<UserTaskVariableFilterRequest> variables) {
        this.variables = variables;
        return this;
    }

    public UserTaskFilterRequest addVariablesItem(UserTaskVariableFilterRequest variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<UserTaskVariableFilterRequest>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UserTaskVariableFilterRequest> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(List<UserTaskVariableFilterRequest> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskFilterRequest userTaskFilterRequest = (UserTaskFilterRequest)o;
        return Objects.equals(this.userTaskKey, userTaskFilterRequest.userTaskKey) && Objects.equals((Object)this.state, (Object)userTaskFilterRequest.state) && Objects.equals(this.assignee, userTaskFilterRequest.assignee) && Objects.equals(this.priority, userTaskFilterRequest.priority) && Objects.equals(this.elementId, userTaskFilterRequest.elementId) && Objects.equals(this.candidateGroup, userTaskFilterRequest.candidateGroup) && Objects.equals(this.candidateUser, userTaskFilterRequest.candidateUser) && Objects.equals(this.processDefinitionKey, userTaskFilterRequest.processDefinitionKey) && Objects.equals(this.processInstanceKey, userTaskFilterRequest.processInstanceKey) && Objects.equals(this.tenantId, userTaskFilterRequest.tenantId) && Objects.equals(this.processDefinitionId, userTaskFilterRequest.processDefinitionId) && Objects.equals(this.elementInstanceKey, userTaskFilterRequest.elementInstanceKey) && Objects.equals(this.variables, userTaskFilterRequest.variables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userTaskKey, this.state, this.assignee, this.priority, this.elementId, this.candidateGroup, this.candidateUser, this.processDefinitionKey, this.processInstanceKey, this.tenantId, this.processDefinitionId, this.elementInstanceKey, this.variables});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserTaskFilterRequest {\n");
        sb.append("    userTaskKey: ").append(this.toIndentedString(this.userTaskKey)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    elementId: ").append(this.toIndentedString(this.elementId)).append("\n");
        sb.append("    candidateGroup: ").append(this.toIndentedString(this.candidateGroup)).append("\n");
        sb.append("    candidateUser: ").append(this.toIndentedString(this.candidateUser)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    elementInstanceKey: ").append(this.toIndentedString(this.elementInstanceKey)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUserTaskKey() != null) {
            try {
                joiner.add(String.format("%suserTaskKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserTaskKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getState() != null) {
            try {
                joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getState()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAssignee() != null) {
            joiner.add(this.getAssignee().toUrlQueryString(prefix + JSON_PROPERTY_ASSIGNEE + suffix));
        }
        if (this.getPriority() != null) {
            joiner.add(this.getPriority().toUrlQueryString(prefix + JSON_PROPERTY_PRIORITY + suffix));
        }
        if (this.getElementId() != null) {
            try {
                joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getElementId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCandidateGroup() != null) {
            joiner.add(this.getCandidateGroup().toUrlQueryString(prefix + JSON_PROPERTY_CANDIDATE_GROUP + suffix));
        }
        if (this.getCandidateUser() != null) {
            joiner.add(this.getCandidateUser().toUrlQueryString(prefix + JSON_PROPERTY_CANDIDATE_USER + suffix));
        }
        if (this.getProcessDefinitionKey() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessInstanceKey() != null) {
            try {
                joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionId() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getElementInstanceKey() != null) {
            try {
                joiner.add(String.format("%selementInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getElementInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVariables() != null) {
            for (int i = 0; i < this.getVariables().size(); ++i) {
                if (this.getVariables().get(i) == null) continue;
                joiner.add(this.getVariables().get(i).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum StateEnum {
        CREATED("CREATED"),
        COMPLETED("COMPLETED"),
        CANCELED("CANCELED"),
        FAILED("FAILED"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

