/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.LongFilterProperty;
import io.camunda.zeebe.client.protocol.rest.StringFilterProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"variableKey", "name", "value", "scopeKey", "processInstanceKey", "tenantId", "isTruncated"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VariableFilterRequest {
    public static final String JSON_PROPERTY_VARIABLE_KEY = "variableKey";
    private LongFilterProperty variableKey;
    public static final String JSON_PROPERTY_NAME = "name";
    private StringFilterProperty name;
    public static final String JSON_PROPERTY_VALUE = "value";
    private StringFilterProperty value;
    public static final String JSON_PROPERTY_SCOPE_KEY = "scopeKey";
    private LongFilterProperty scopeKey;
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
    private LongFilterProperty processInstanceKey;
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId;
    public static final String JSON_PROPERTY_IS_TRUNCATED = "isTruncated";
    private Boolean isTruncated;

    public VariableFilterRequest variableKey(LongFilterProperty variableKey) {
        this.variableKey = variableKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="variableKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LongFilterProperty getVariableKey() {
        return this.variableKey;
    }

    @JsonProperty(value="variableKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariableKey(LongFilterProperty variableKey) {
        this.variableKey = variableKey;
    }

    public VariableFilterRequest name(StringFilterProperty name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StringFilterProperty getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(StringFilterProperty name) {
        this.name = name;
    }

    public VariableFilterRequest value(StringFilterProperty value) {
        this.value = value;
        return this;
    }

    @Nullable
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StringFilterProperty getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(StringFilterProperty value) {
        this.value = value;
    }

    public VariableFilterRequest scopeKey(LongFilterProperty scopeKey) {
        this.scopeKey = scopeKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="scopeKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LongFilterProperty getScopeKey() {
        return this.scopeKey;
    }

    @JsonProperty(value="scopeKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopeKey(LongFilterProperty scopeKey) {
        this.scopeKey = scopeKey;
    }

    public VariableFilterRequest processInstanceKey(LongFilterProperty processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LongFilterProperty getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @JsonProperty(value="processInstanceKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceKey(LongFilterProperty processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public VariableFilterRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public VariableFilterRequest isTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    @Nullable
    @JsonProperty(value="isTruncated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    @JsonProperty(value="isTruncated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableFilterRequest variableFilterRequest = (VariableFilterRequest)o;
        return Objects.equals(this.variableKey, variableFilterRequest.variableKey) && Objects.equals(this.name, variableFilterRequest.name) && Objects.equals(this.value, variableFilterRequest.value) && Objects.equals(this.scopeKey, variableFilterRequest.scopeKey) && Objects.equals(this.processInstanceKey, variableFilterRequest.processInstanceKey) && Objects.equals(this.tenantId, variableFilterRequest.tenantId) && Objects.equals(this.isTruncated, variableFilterRequest.isTruncated);
    }

    public int hashCode() {
        return Objects.hash(this.variableKey, this.name, this.value, this.scopeKey, this.processInstanceKey, this.tenantId, this.isTruncated);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VariableFilterRequest {\n");
        sb.append("    variableKey: ").append(this.toIndentedString(this.variableKey)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    scopeKey: ").append(this.toIndentedString(this.scopeKey)).append("\n");
        sb.append("    processInstanceKey: ").append(this.toIndentedString(this.processInstanceKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    isTruncated: ").append(this.toIndentedString(this.isTruncated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVariableKey() != null) {
            joiner.add(this.getVariableKey().toUrlQueryString(prefix + JSON_PROPERTY_VARIABLE_KEY + suffix));
        }
        if (this.getName() != null) {
            joiner.add(this.getName().toUrlQueryString(prefix + JSON_PROPERTY_NAME + suffix));
        }
        if (this.getValue() != null) {
            joiner.add(this.getValue().toUrlQueryString(prefix + JSON_PROPERTY_VALUE + suffix));
        }
        if (this.getScopeKey() != null) {
            joiner.add(this.getScopeKey().toUrlQueryString(prefix + JSON_PROPERTY_SCOPE_KEY + suffix));
        }
        if (this.getProcessInstanceKey() != null) {
            joiner.add(this.getProcessInstanceKey().toUrlQueryString(prefix + JSON_PROPERTY_PROCESS_INSTANCE_KEY + suffix));
        }
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIsTruncated() != null) {
            try {
                joiner.add(String.format("%sisTruncated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsTruncated()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

