/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.DocumentReferenceBatchResponse;
import io.camunda.zeebe.client.api.response.DocumentReferenceResponse;
import io.camunda.zeebe.client.impl.response.DocumentReferenceResponseImpl;
import io.camunda.zeebe.client.protocol.rest.DocumentCreationBatchResponse;
import io.camunda.zeebe.client.protocol.rest.DocumentCreationFailureDetail;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DocumentReferenceBatchResponseImpl
implements DocumentReferenceBatchResponse {
    private final DocumentCreationBatchResponse response;

    public DocumentReferenceBatchResponseImpl(DocumentCreationBatchResponse response) {
        this.response = response;
    }

    @Override
    public boolean isSuccessful() {
        return this.response.getFailedDocuments() == null || this.response.getFailedDocuments().isEmpty();
    }

    @Override
    public List<DocumentReferenceResponse> getCreatedDocuments() {
        if (this.response.getCreatedDocuments() == null) {
            return Collections.emptyList();
        }
        return this.response.getCreatedDocuments().stream().map(DocumentReferenceResponseImpl::new).collect(Collectors.toList());
    }

    @Override
    public List<DocumentReferenceBatchResponse.FailedDocumentDetail> getFailedDocuments() {
        if (this.response.getFailedDocuments() == null) {
            return Collections.emptyList();
        }
        return this.response.getFailedDocuments().stream().map(FailedDocumentDetailImpl::new).collect(Collectors.toList());
    }

    public static class FailedDocumentDetailImpl
    implements DocumentReferenceBatchResponse.FailedDocumentDetail {
        private final DocumentCreationFailureDetail failedDocumentDetail;

        public FailedDocumentDetailImpl(DocumentCreationFailureDetail failedDocumentDetail) {
            this.failedDocumentDetail = failedDocumentDetail;
        }

        @Override
        public String getFilename() {
            return this.failedDocumentDetail.getFilename();
        }

        @Override
        public String getDetail() {
            return this.failedDocumentDetail.getDetail();
        }
    }
}

