/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.response;

import io.camunda.zeebe.client.api.search.response.ProcessInstance;
import io.camunda.zeebe.client.impl.search.response.OperationImpl;
import io.camunda.zeebe.client.impl.search.response.ProcessInstanceReferenceImpl;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceItem;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProcessInstanceImpl
implements ProcessInstance {
    private final Long key;
    private final String processName;
    private final Integer processVersion;
    private final String bpmnProcessId;
    private final Long parentProcessInstanceKey;
    private final Long parentFlowNodeInstanceKey;
    private final String startDate;
    private final String endDate;
    private final String state;
    private final Boolean incident;
    private final Boolean hasActiveOperation;
    private final Long processDefinitionKey;
    private final String tenantId;
    private final String rootInstanceId;
    private final List<OperationImpl> operations;
    private final List<ProcessInstanceReferenceImpl> callHierarchy;

    public ProcessInstanceImpl(ProcessInstanceItem item) {
        this.key = item.getKey();
        this.processName = item.getProcessDefinitionName();
        this.processVersion = item.getProcessDefinitionVersion();
        this.bpmnProcessId = item.getBpmnProcessId();
        this.parentProcessInstanceKey = item.getParentKey();
        this.parentFlowNodeInstanceKey = item.getParentFlowNodeInstanceKey();
        this.startDate = item.getStartDate();
        this.endDate = item.getEndDate();
        this.state = Optional.ofNullable(item.getState()).map(Enum::toString).orElse(null);
        this.incident = item.getIncident();
        this.hasActiveOperation = item.getHasActiveOperation();
        this.processDefinitionKey = item.getProcessDefinitionKey();
        this.tenantId = item.getTenantId();
        this.rootInstanceId = item.getRootInstanceId();
        this.operations = item.getOperations() == null ? null : item.getOperations().stream().map(OperationImpl::new).collect(Collectors.toList());
        this.callHierarchy = item.getCallHierarchy() == null ? null : item.getCallHierarchy().stream().map(ProcessInstanceReferenceImpl::new).collect(Collectors.toList());
    }

    @Override
    public Long getKey() {
        return this.key;
    }

    @Override
    public String getProcessName() {
        return this.processName;
    }

    @Override
    public Integer getProcessVersion() {
        return this.processVersion;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public Long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKey;
    }

    @Override
    public Long getParentFlowNodeInstanceKey() {
        return this.parentFlowNodeInstanceKey;
    }

    @Override
    public String getStartDate() {
        return this.startDate;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public Boolean getIncident() {
        return this.incident;
    }

    @Override
    public Boolean getHasActiveOperation() {
        return this.hasActiveOperation;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getRootInstanceId() {
        return this.rootInstanceId;
    }

    @Override
    public List<OperationImpl> getOperations() {
        return this.operations;
    }

    @Override
    public List<ProcessInstanceReferenceImpl> getCallHierarchy() {
        return this.callHierarchy;
    }
}

