/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ActivatedJobResult
 */
@JsonPropertyOrder({
  ActivatedJobResult.JSON_PROPERTY_JOB_KEY,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ActivatedJobResult.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  ActivatedJobResult.JSON_PROPERTY_TYPE,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ActivatedJobResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ActivatedJobResult.JSON_PROPERTY_ELEMENT_ID,
  ActivatedJobResult.JSON_PROPERTY_CUSTOM_HEADERS,
  ActivatedJobResult.JSON_PROPERTY_WORKER,
  ActivatedJobResult.JSON_PROPERTY_RETRIES,
  ActivatedJobResult.JSON_PROPERTY_DEADLINE,
  ActivatedJobResult.JSON_PROPERTY_VARIABLES,
  ActivatedJobResult.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-05T12:55:03.727493308Z[GMT]", comments = "Generator version: 7.8.0")
public class ActivatedJobResult {
  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  private String jobKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  private String elementInstanceKey;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  private String elementId;

  public static final String JSON_PROPERTY_CUSTOM_HEADERS = "customHeaders";
  private Map<String, Object> customHeaders = new HashMap<>();

  public static final String JSON_PROPERTY_WORKER = "worker";
  private String worker;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private Integer retries;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private Long deadline;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public ActivatedJobResult() {
  }

  public ActivatedJobResult jobKey(String jobKey) {
    
    this.jobKey = jobKey;
    return this;
  }

  /**
   * the key, a unique identifier for the job
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJobKey() {
    return jobKey;
  }


  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(String jobKey) {
    this.jobKey = jobKey;
  }

  public ActivatedJobResult processInstanceKey(String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * the job&#39;s process instance key©
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ActivatedJobResult processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * the key of the job&#39;s process definition
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ActivatedJobResult elementInstanceKey(String elementInstanceKey) {
    
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * the unique key identifying the associated task, unique within the scope of the process instance 
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementInstanceKey() {
    return elementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(String elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ActivatedJobResult type(String type) {
    
    this.type = type;
    return this;
  }

  /**
   * the type of the job (should match what was requested)
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  public ActivatedJobResult processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * the bpmn process ID of the job&#39;s process definition
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ActivatedJobResult processDefinitionVersion(Integer processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * the version of the job&#39;s process definition
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ActivatedJobResult elementId(String elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * the associated task element ID
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(String elementId) {
    this.elementId = elementId;
  }

  public ActivatedJobResult customHeaders(Map<String, Object> customHeaders) {
    
    this.customHeaders = customHeaders;
    return this;
  }

  public ActivatedJobResult putCustomHeadersItem(String key, Object customHeadersItem) {
    if (this.customHeaders == null) {
      this.customHeaders = new HashMap<>();
    }
    this.customHeaders.put(key, customHeadersItem);
    return this;
  }

  /**
   * a set of custom headers defined during modelling; returned as a serialized JSON document
   * @return customHeaders
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_HEADERS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getCustomHeaders() {
    return customHeaders;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_HEADERS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomHeaders(Map<String, Object> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public ActivatedJobResult worker(String worker) {
    
    this.worker = worker;
    return this;
  }

  /**
   * the name of the worker which activated this job
   * @return worker
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWorker() {
    return worker;
  }


  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorker(String worker) {
    this.worker = worker;
  }

  public ActivatedJobResult retries(Integer retries) {
    
    this.retries = retries;
    return this;
  }

  /**
   * the amount of retries left to this job (should always be positive)
   * @return retries
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRetries() {
    return retries;
  }


  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(Integer retries) {
    this.retries = retries;
  }

  public ActivatedJobResult deadline(Long deadline) {
    
    this.deadline = deadline;
    return this;
  }

  /**
   * when the job can be activated again, sent as a UNIX epoch timestamp
   * @return deadline
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDeadline() {
    return deadline;
  }


  @JsonProperty(JSON_PROPERTY_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeadline(Long deadline) {
    this.deadline = deadline;
  }

  public ActivatedJobResult variables(Map<String, Object> variables) {
    
    this.variables = variables;
    return this;
  }

  public ActivatedJobResult putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All variables visible to the task scope, computed at activation time
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public ActivatedJobResult tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The ID of the tenant that owns the job
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivatedJobResult activatedJobResult = (ActivatedJobResult) o;
    return Objects.equals(this.jobKey, activatedJobResult.jobKey) &&
        Objects.equals(this.processInstanceKey, activatedJobResult.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, activatedJobResult.processDefinitionKey) &&
        Objects.equals(this.elementInstanceKey, activatedJobResult.elementInstanceKey) &&
        Objects.equals(this.type, activatedJobResult.type) &&
        Objects.equals(this.processDefinitionId, activatedJobResult.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, activatedJobResult.processDefinitionVersion) &&
        Objects.equals(this.elementId, activatedJobResult.elementId) &&
        Objects.equals(this.customHeaders, activatedJobResult.customHeaders) &&
        Objects.equals(this.worker, activatedJobResult.worker) &&
        Objects.equals(this.retries, activatedJobResult.retries) &&
        Objects.equals(this.deadline, activatedJobResult.deadline) &&
        Objects.equals(this.variables, activatedJobResult.variables) &&
        Objects.equals(this.tenantId, activatedJobResult.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobKey, processInstanceKey, processDefinitionKey, elementInstanceKey, type, processDefinitionId, processDefinitionVersion, elementId, customHeaders, worker, retries, deadline, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivatedJobResult {\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    customHeaders: ").append(toIndentedString(customHeaders)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      try {
        joiner.add(String.format("%selementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `customHeaders` to the URL query string
    if (getCustomHeaders() != null) {
      for (String _key : getCustomHeaders().keySet()) {
        try {
          joiner.add(String.format("%scustomHeaders%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getCustomHeaders().get(_key), URLEncoder.encode(String.valueOf(getCustomHeaders().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `worker` to the URL query string
    if (getWorker() != null) {
      try {
        joiner.add(String.format("%sworker%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorker()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deadline` to the URL query string
    if (getDeadline() != null) {
      try {
        joiner.add(String.format("%sdeadline%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeadline()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        try {
          joiner.add(String.format("%svariables%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getVariables().get(_key), URLEncoder.encode(String.valueOf(getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

