/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * SearchQueryPageRequest
 */
@JsonPropertyOrder({
  SearchQueryPageRequest.JSON_PROPERTY_FROM,
  SearchQueryPageRequest.JSON_PROPERTY_LIMIT,
  SearchQueryPageRequest.JSON_PROPERTY_SEARCH_AFTER,
  SearchQueryPageRequest.JSON_PROPERTY_SEARCH_BEFORE
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-05T12:55:03.727493308Z[GMT]", comments = "Generator version: 7.8.0")
public class SearchQueryPageRequest {
  public static final String JSON_PROPERTY_FROM = "from";
  private Integer from;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private Integer limit;

  public static final String JSON_PROPERTY_SEARCH_AFTER = "searchAfter";
  private List<Object> searchAfter = new ArrayList<>();

  public static final String JSON_PROPERTY_SEARCH_BEFORE = "searchBefore";
  private List<Object> searchBefore = new ArrayList<>();

  public SearchQueryPageRequest() {
  }

  public SearchQueryPageRequest from(Integer from) {
    
    this.from = from;
    return this;
  }

  /**
   * Get from
   * @return from
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(Integer from) {
    this.from = from;
  }

  public SearchQueryPageRequest limit(Integer limit) {
    
    this.limit = limit;
    return this;
  }

  /**
   * Get limit
   * @return limit
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public SearchQueryPageRequest searchAfter(List<Object> searchAfter) {
    
    this.searchAfter = searchAfter;
    return this;
  }

  public SearchQueryPageRequest addSearchAfterItem(Object searchAfterItem) {
    if (this.searchAfter == null) {
      this.searchAfter = new ArrayList<>();
    }
    this.searchAfter.add(searchAfterItem);
    return this;
  }

  /**
   * Get searchAfter
   * @return searchAfter
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEARCH_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getSearchAfter() {
    return searchAfter;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchAfter(List<Object> searchAfter) {
    this.searchAfter = searchAfter;
  }

  public SearchQueryPageRequest searchBefore(List<Object> searchBefore) {
    
    this.searchBefore = searchBefore;
    return this;
  }

  public SearchQueryPageRequest addSearchBeforeItem(Object searchBeforeItem) {
    if (this.searchBefore == null) {
      this.searchBefore = new ArrayList<>();
    }
    this.searchBefore.add(searchBeforeItem);
    return this;
  }

  /**
   * Get searchBefore
   * @return searchBefore
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEARCH_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getSearchBefore() {
    return searchBefore;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchBefore(List<Object> searchBefore) {
    this.searchBefore = searchBefore;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchQueryPageRequest searchQueryPageRequest = (SearchQueryPageRequest) o;
    return Objects.equals(this.from, searchQueryPageRequest.from) &&
        Objects.equals(this.limit, searchQueryPageRequest.limit) &&
        Objects.equals(this.searchAfter, searchQueryPageRequest.searchAfter) &&
        Objects.equals(this.searchBefore, searchQueryPageRequest.searchBefore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, limit, searchAfter, searchBefore);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchQueryPageRequest {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    searchAfter: ").append(toIndentedString(searchAfter)).append("\n");
    sb.append("    searchBefore: ").append(toIndentedString(searchBefore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `from` to the URL query string
    if (getFrom() != null) {
      try {
        joiner.add(String.format("%sfrom%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFrom()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `limit` to the URL query string
    if (getLimit() != null) {
      try {
        joiner.add(String.format("%slimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `searchAfter` to the URL query string
    if (getSearchAfter() != null) {
      for (int i = 0; i < getSearchAfter().size(); i++) {
        try {
          joiner.add(String.format("%ssearchAfter%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSearchAfter().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `searchBefore` to the URL query string
    if (getSearchBefore() != null) {
      for (int i = 0; i < getSearchBefore().size(); i++) {
        try {
          joiner.add(String.format("%ssearchBefore%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSearchBefore().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

