/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.AssignUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.AssignUserTaskResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.protocol.rest.UserTaskAssignmentRequest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class AssignUserTaskCommandImpl
implements AssignUserTaskCommandStep1 {
    private final long userTaskKey;
    private final UserTaskAssignmentRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public AssignUserTaskCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long userTaskKey) {
        this.jsonMapper = jsonMapper;
        this.userTaskKey = userTaskKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserTaskAssignmentRequest();
    }

    @Override
    public FinalCommandStep<AssignUserTaskResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<AssignUserTaskResponse> send() {
        HttpZeebeFuture<AssignUserTaskResponse> result = new HttpZeebeFuture<AssignUserTaskResponse>();
        this.httpClient.post("/user-tasks/" + this.userTaskKey + "/assignment", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }

    @Override
    public AssignUserTaskCommandStep1 action(String action) {
        this.request.setAction(action);
        return this;
    }

    @Override
    public AssignUserTaskCommandStep1 assignee(String assignee) {
        ArgumentUtil.ensureNotNull("assignee", assignee);
        this.request.setAssignee(assignee);
        return this;
    }

    @Override
    public AssignUserTaskCommandStep1 allowOverride(boolean allowOverride) {
        this.request.setAllowOverride(allowOverride);
        return this;
    }
}

