/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.oauth;

import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProvider;
import io.camunda.zeebe.client.impl.util.Environment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class OAuthCredentialsProviderBuilder {
    public static final String INVALID_ARGUMENT_MSG = "Expected valid %s but none was provided.";
    public static final String OAUTH_ENV_CLIENT_ID = "ZEEBE_CLIENT_ID";
    public static final String OAUTH_ENV_CLIENT_SECRET = "ZEEBE_CLIENT_SECRET";
    public static final String OAUTH_ENV_TOKEN_AUDIENCE = "ZEEBE_TOKEN_AUDIENCE";
    public static final String OAUTH_ENV_TOKEN_SCOPE = "ZEEBE_TOKEN_SCOPE";
    public static final String OAUTH_ENV_AUTHORIZATION_SERVER = "ZEEBE_AUTHORIZATION_SERVER_URL";
    public static final String OAUTH_ENV_CACHE_PATH = "ZEEBE_CLIENT_CONFIG_PATH";
    public static final String OAUTH_ENV_CONNECT_TIMEOUT = "ZEEBE_AUTH_CONNECT_TIMEOUT";
    public static final String OAUTH_ENV_READ_TIMEOUT = "ZEEBE_AUTH_READ_TIMEOUT";
    public static final String OAUTH_ENV_SSL_CLIENT_CERT_PATH = "OAUTH_SSL_CLIENT_CERT_PATH";
    public static final String OAUTH_ENV_SSL_CLIENT_CERT_PASSWORD = "OAUTH_SSL_CLIENT_CERT_PASSWORD";
    public static final String OAUTH_ENV_ISSUER = "OAUTH_ISSUER";
    private static final String DEFAULT_AUTHZ_SERVER = "https://login.cloud.camunda.io/oauth/token/";
    private static final Duration DEFAULT_CONNECT_TIMEOUT;
    private static final Duration DEFAULT_READ_TIMEOUT;
    private String clientId;
    private String issuer;
    private String clientSecret;
    private String audience;
    private String scope;
    private String authorizationServerUrl;
    private URL authorizationServer;
    private String credentialsCachePath;
    private File credentialsCache;
    private Duration connectTimeout;
    private Duration readTimeout;
    private boolean applyEnvironmentOverrides = true;
    private Path sslClientCertPath;
    private String sslClientCertPassword;

    public OAuthCredentialsProviderBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    String getClientId() {
        return this.clientId;
    }

    public OAuthCredentialsProviderBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    String getClientSecret() {
        return this.clientSecret;
    }

    public OAuthCredentialsProviderBuilder audience(String audience) {
        this.audience = audience;
        return this;
    }

    String getAudience() {
        return this.audience;
    }

    public OAuthCredentialsProviderBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    String getScope() {
        return this.scope;
    }

    public OAuthCredentialsProviderBuilder authorizationServerUrl(String authorizationServerUrl) {
        this.authorizationServerUrl = authorizationServerUrl;
        return this;
    }

    URL getAuthorizationServer() {
        return this.authorizationServer;
    }

    public OAuthCredentialsProviderBuilder credentialsCachePath(String cachePath) {
        this.credentialsCachePath = cachePath;
        return this;
    }

    File getCredentialsCache() {
        return this.credentialsCache;
    }

    public OAuthCredentialsProviderBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public OAuthCredentialsProviderBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public OAuthCredentialsProvider build() {
        if (this.applyEnvironmentOverrides) {
            this.checkEnvironmentOverrides();
        }
        this.applyDefaults();
        this.applySSLClientCertConfiguration();
        this.validate();
        return new OAuthCredentialsProvider(this);
    }

    private void applySSLClientCertConfiguration() {
        OAuthCredentialsProviderBuilder.applyEnvironmentValueIfNotNull(this::sslClientCertPath, OAUTH_ENV_SSL_CLIENT_CERT_PATH);
        OAuthCredentialsProviderBuilder.applyEnvironmentValueIfNotNull(this::sslClientCertPassword, OAUTH_ENV_SSL_CLIENT_CERT_PASSWORD);
        OAuthCredentialsProviderBuilder.applyEnvironmentValueIfNotNull(this::issuer, OAUTH_ENV_ISSUER);
    }

    private void checkEnvironmentOverrides() {
        String envClientId = Environment.system().get(OAUTH_ENV_CLIENT_ID);
        String envClientSecret = Environment.system().get(OAUTH_ENV_CLIENT_SECRET);
        String envAudience = Environment.system().get(OAUTH_ENV_TOKEN_AUDIENCE);
        String envScope = Environment.system().get(OAUTH_ENV_TOKEN_SCOPE);
        String envAuthorizationUrl = Environment.system().get(OAUTH_ENV_AUTHORIZATION_SERVER);
        String envCachePath = Environment.system().get(OAUTH_ENV_CACHE_PATH);
        String envReadTimeout = Environment.system().get(OAUTH_ENV_READ_TIMEOUT);
        String envConnectTimeout = Environment.system().get(OAUTH_ENV_CONNECT_TIMEOUT);
        if (envClientId != null) {
            this.clientId = envClientId;
        }
        if (envClientSecret != null) {
            this.clientSecret = envClientSecret;
        }
        if (envAudience != null) {
            this.audience = envAudience;
        }
        if (envScope != null) {
            this.scope = envScope;
        }
        if (envAuthorizationUrl != null) {
            this.authorizationServerUrl = envAuthorizationUrl;
        }
        if (envCachePath != null) {
            this.credentialsCachePath = envCachePath;
        }
        if (envConnectTimeout != null) {
            this.connectTimeout = Duration.ofMillis(Long.parseLong(envConnectTimeout));
        }
        if (envReadTimeout != null) {
            this.readTimeout = Duration.ofMillis(Long.parseLong(envReadTimeout));
        }
    }

    private void applyDefaults() {
        if (this.credentialsCachePath == null) {
            this.credentialsCachePath = Paths.get(System.getProperty("user.home"), ".camunda", "credentials").toAbsolutePath().toString();
        }
        if (this.authorizationServerUrl == null) {
            this.authorizationServerUrl = DEFAULT_AUTHZ_SERVER;
        }
        if (this.connectTimeout == null) {
            this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        }
        if (this.readTimeout == null) {
            this.readTimeout = DEFAULT_READ_TIMEOUT;
        }
    }

    private void validate() {
        try {
            Objects.requireNonNull(this.clientId, String.format(INVALID_ARGUMENT_MSG, "client id"));
            if (this.sslClientCertConfigurationProvided()) {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(Files.newInputStream(Paths.get(this.sslClientCertPath.toAbsolutePath().toString(), new String[0]), new OpenOption[0]), this.sslClientCertPassword.toCharArray());
            } else {
                Objects.requireNonNull(this.clientSecret, String.format(INVALID_ARGUMENT_MSG, "client secret"));
            }
            Objects.requireNonNull(this.audience, String.format(INVALID_ARGUMENT_MSG, "audience"));
            Objects.requireNonNull(this.authorizationServerUrl, String.format(INVALID_ARGUMENT_MSG, "authorization server URL"));
            this.authorizationServer = new URL(this.authorizationServerUrl);
            this.credentialsCache = new File(this.credentialsCachePath);
            if (this.credentialsCache.isDirectory()) {
                throw new IllegalArgumentException("Expected specified credentials cache to be a file but found directory instead.");
            }
            this.validateTimeout(this.connectTimeout, "ConnectTimeout");
            this.validateTimeout(this.readTimeout, "ReadTimeout");
        }
        catch (IOException | NullPointerException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void validateTimeout(Duration timeout, String timeoutName) {
        if (timeout.isZero() || timeout.isNegative() || timeout.toMillis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("%s timeout is %s milliseconds, expected timeout to be a positive number of milliseconds smaller than %s.", timeoutName, timeout.toMillis(), Integer.MAX_VALUE));
        }
    }

    public OAuthCredentialsProviderBuilder sslClientCertPath(String entraCertificatePath) {
        if (entraCertificatePath != null) {
            this.sslClientCertPath = Paths.get(entraCertificatePath, new String[0]);
        }
        return this;
    }

    public Path getSslClientCertPath() {
        return this.sslClientCertPath;
    }

    public OAuthCredentialsProviderBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public OAuthCredentialsProviderBuilder sslClientCertPassword(String entraCertificatePassword) {
        this.sslClientCertPassword = entraCertificatePassword;
        return this;
    }

    public String getSslClientCertPassword() {
        return this.sslClientCertPassword;
    }

    public boolean sslClientCertConfigurationProvided() {
        return this.sslClientCertPassword != null && !this.sslClientCertPassword.isEmpty() && this.sslClientCertPath != null && this.sslClientCertPath.toFile().exists();
    }

    public OAuthCredentialsProviderBuilder applyEnvironmentOverrides(boolean applyEnvironmentOverrides) {
        this.applyEnvironmentOverrides = applyEnvironmentOverrides;
        return this;
    }

    private static Optional<String> getEnvironmentVariableValue(String envName) {
        return Optional.ofNullable(Environment.system().get(envName));
    }

    private static void applyEnvironmentValueIfNotNull(Consumer<String> action, String ... envNames) {
        for (String envName : envNames) {
            Optional<String> value = OAuthCredentialsProviderBuilder.getEnvironmentVariableValue(envName);
            value.ifPresent(action);
            if (value.isPresent()) break;
        }
    }

    static {
        DEFAULT_READ_TIMEOUT = DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    }
}

