/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.FailJobResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.FailJobResponseImpl;
import io.camunda.zeebe.client.protocol.rest.JobFailRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class FailJobCommandImpl
extends CommandWithVariables<FailJobCommandStep1.FailJobCommandStep2>
implements FailJobCommandStep1,
FailJobCommandStep1.FailJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.FailJobRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private boolean useRest;
    private final JobFailRequest httpRequestObject;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long jobKey;

    public FailJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.FailJobRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(key);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobFailRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = key;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 retries(int retries) {
        this.grpcRequestObjectBuilder.setRetries(retries);
        this.httpRequestObject.setRetries(retries);
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 retryBackoff(Duration backoffTimeout) {
        this.grpcRequestObjectBuilder.setRetryBackOff(backoffTimeout.toMillis());
        this.httpRequestObject.setRetryBackOff(backoffTimeout.toMillis());
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 errorMessage(String errorMsg) {
        this.grpcRequestObjectBuilder.setErrorMessage(errorMsg);
        this.httpRequestObject.setErrorMessage(errorMsg);
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.objectMapper.fromJsonAsMap(variables));
        }
        return this;
    }

    @Override
    public FinalCommandStep<FailJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<FailJobResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<FailJobResponse> sendRestRequest() {
        HttpZeebeFuture<FailJobResponse> result = new HttpZeebeFuture<FailJobResponse>();
        this.httpClient.post("/jobs/" + this.jobKey + "/failure", this.objectMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private ZeebeFuture<FailJobResponse> sendGrpcRequest() {
        GatewayOuterClass.FailJobRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<FailJobResponse, GatewayOuterClass.FailJobResponse> future = new RetriableClientFutureImpl<FailJobResponse, GatewayOuterClass.FailJobResponse>(FailJobResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.FailJobResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.FailJobResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).failJob(request, streamObserver);
    }

    @Override
    public FailJobCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public FailJobCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

