/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientCloudBuilderStep1;
import io.camunda.zeebe.client.api.ExperimentalApi;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.BuilderUtils;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.grpc.ClientInterceptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;

@Deprecated
public class ZeebeClientCloudBuilderImpl
implements ZeebeClientCloudBuilderStep1,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4,
ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4.ZeebeClientCloudBuilderStep5 {
    private static final String DEFAULT_DOMAIN = "camunda.io";
    private static final String DEFAULT_REGION = "bru-2";
    private static final String ZEEBE_DOMAIN_COMPONENT = "zeebe";
    private final ZeebeClientBuilderImpl innerBuilder = new ZeebeClientBuilderImpl();
    private String clusterId;
    private String clientId;
    private String clientSecret;
    private String region = "bru-2";
    private String domain = "camunda.io";

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2 withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3 withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4.ZeebeClientCloudBuilderStep5 withRegion(String region) {
        this.region = region;
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4.ZeebeClientCloudBuilderStep5 withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public ZeebeClientBuilder withProperties(Properties properties) {
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.cloud.clusterId", this::withClusterId);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.cloud.clientId", this::withClientId);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.cloud.secret", this::withClientId);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.cloud.region", this::withRegion);
        BuilderUtils.applyIfNotNull(properties, "zeebe.client.worker.stream.enabled", value -> this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(value)));
        this.innerBuilder.withProperties(properties);
        this.innerBuilder.defaultTenantId("");
        this.innerBuilder.defaultJobWorkerTenantIds(Collections.emptyList());
        return this;
    }

    @Override
    public ZeebeClientBuilder applyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.innerBuilder.applyEnvironmentVariableOverrides(applyEnvironmentVariableOverrides);
        return this;
    }

    @Override
    public ZeebeClientBuilder gatewayAddress(String gatewayAddress) {
        this.innerBuilder.gatewayAddress(gatewayAddress);
        return this;
    }

    @Override
    public ZeebeClientBuilder restAddress(URI restAddress) {
        this.innerBuilder.restAddress(restAddress);
        return this;
    }

    @Override
    public ZeebeClientBuilder grpcAddress(URI grpcAddress) {
        this.innerBuilder.grpcAddress(grpcAddress);
        return this;
    }

    @Override
    @ExperimentalApi(value="https://github.com/camunda/camunda/issues/14106")
    public ZeebeClientBuilder defaultTenantId(String tenantId) {
        Loggers.LOGGER.debug("Multi-tenancy in Camunda 8 SaaS will be supported with https://github.com/camunda/camunda/issues/14106.");
        return this;
    }

    @Override
    @ExperimentalApi(value="https://github.com/camunda/camunda/issues/14106")
    public ZeebeClientBuilder defaultJobWorkerTenantIds(List<String> tenantIds) {
        Loggers.LOGGER.debug("Multi-tenancy in Camunda 8 SaaS will be supported with https://github.com/camunda/camunda/issues/14106.");
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.innerBuilder.defaultJobWorkerMaxJobsActive(maxJobsActive);
        return this;
    }

    @Override
    public ZeebeClientBuilder numJobWorkerExecutionThreads(int numThreads) {
        this.innerBuilder.numJobWorkerExecutionThreads(numThreads);
        return this;
    }

    @Override
    public ZeebeClientBuilder jobWorkerExecutor(ScheduledExecutorService executor, boolean takeOwnership) {
        this.innerBuilder.jobWorkerExecutor(executor, takeOwnership);
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerName(String workerName) {
        this.innerBuilder.defaultJobWorkerName(workerName);
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobTimeout(Duration timeout) {
        this.innerBuilder.defaultJobTimeout(timeout);
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobPollInterval(Duration pollInterval) {
        this.innerBuilder.defaultJobPollInterval(pollInterval);
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultMessageTimeToLive(Duration timeToLive) {
        this.innerBuilder.defaultMessageTimeToLive(timeToLive);
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultRequestTimeout(Duration requestTimeout) {
        this.innerBuilder.defaultRequestTimeout(requestTimeout);
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultRequestTimeoutOffset(Duration requestTimeoutOffset) {
        this.innerBuilder.defaultRequestTimeoutOffset(requestTimeoutOffset);
        return this;
    }

    @Override
    public ZeebeClientBuilder usePlaintext() {
        this.innerBuilder.usePlaintext();
        return this;
    }

    @Override
    public ZeebeClientBuilder caCertificatePath(String certificatePath) {
        this.innerBuilder.caCertificatePath(certificatePath);
        return this;
    }

    @Override
    public ZeebeClientBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.innerBuilder.credentialsProvider(credentialsProvider);
        return this;
    }

    @Override
    public ZeebeClientBuilder keepAlive(Duration keepAlive) {
        this.innerBuilder.keepAlive(keepAlive);
        return this;
    }

    @Override
    public ZeebeClientBuilder withInterceptors(ClientInterceptor ... interceptor) {
        this.innerBuilder.withInterceptors(interceptor);
        return this;
    }

    @Override
    public ZeebeClientCloudBuilderStep1.ZeebeClientCloudBuilderStep2.ZeebeClientCloudBuilderStep3.ZeebeClientCloudBuilderStep4 withChainHandlers(AsyncExecChainHandler ... chainHandler) {
        this.innerBuilder.withChainHandlers(chainHandler);
        return this;
    }

    @Override
    public ZeebeClientBuilder withJsonMapper(JsonMapper jsonMapper) {
        this.innerBuilder.withJsonMapper(jsonMapper);
        return this;
    }

    @Override
    public ZeebeClientBuilder overrideAuthority(String authority) {
        this.innerBuilder.overrideAuthority(authority);
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMessageSize(int maxMessageSize) {
        this.innerBuilder.maxMessageSize(maxMessageSize);
        return this;
    }

    @Override
    public ZeebeClientBuilder maxMetadataSize(int maxMetadataSize) {
        return this.innerBuilder.maxMetadataSize(maxMetadataSize);
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerStreamEnabled(boolean streamEnabled) {
        this.innerBuilder.defaultJobWorkerStreamEnabled(streamEnabled);
        return this;
    }

    @Override
    public ZeebeClientBuilder useDefaultRetryPolicy(boolean useDefaultRetryPolicy) {
        this.innerBuilder.useDefaultRetryPolicy(useDefaultRetryPolicy);
        return this;
    }

    @Override
    public ZeebeClientBuilder preferRestOverGrpc(boolean preferRestOverGrpc) {
        this.innerBuilder.preferRestOverGrpc(preferRestOverGrpc);
        return this;
    }

    @Override
    public ZeebeClient build() {
        this.innerBuilder.grpcAddress(this.determineGrpcAddress());
        this.innerBuilder.restAddress(this.determineRestAddress());
        this.innerBuilder.credentialsProvider(this.determineCredentialsProvider());
        return this.innerBuilder.build();
    }

    private URI determineRestAddress() {
        if (this.isNeedToSetCloudRestAddress()) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            String cloudRestAddress = String.format("https://%s.%s.%s:443/%s", this.region, ZEEBE_DOMAIN_COMPONENT, this.domain, this.clusterId);
            return this.getURIFromString(cloudRestAddress);
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id' to set REST API address in the client cloud builder, but overwriting with explicitly defined REST API address: {}.", (Object)this.innerBuilder.getRestAddress());
        return this.innerBuilder.getRestAddress();
    }

    private URI determineGrpcAddress() {
        if (this.isNeedToSetCloudGrpcAddress() && this.isNeedToSetCloudGatewayAddress()) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            String cloudGrpcAddress = String.format("https://%s.%s.%s.%s:443", this.clusterId, this.region, ZEEBE_DOMAIN_COMPONENT, this.domain);
            return this.getURIFromString(cloudGrpcAddress);
        }
        if (!this.isNeedToSetCloudGrpcAddress()) {
            Loggers.LOGGER.debug("Expected to use 'cluster id' to set gateway address in the client cloud builder, but overwriting with explicitly defined gateway address: {}.", (Object)this.innerBuilder.getGrpcAddress());
            return this.innerBuilder.getGrpcAddress();
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id' to set gateway address in the client cloud builder, but overwriting with explicitly defined gateway address: {}.", (Object)this.innerBuilder.getGatewayAddress());
        return this.getURIFromString("https://" + this.innerBuilder.getGatewayAddress());
    }

    private CredentialsProvider determineCredentialsProvider() {
        CredentialsProvider provider = this.innerBuilder.getCredentialsProvider();
        if (provider == null) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            ArgumentUtil.ensureNotNull("client id", this.clientId);
            ArgumentUtil.ensureNotNull("client secret", this.clientSecret);
            OAuthCredentialsProviderBuilder builder = new OAuthCredentialsProviderBuilder();
            if (this.innerBuilder.isPlaintextConnectionEnabled()) {
                Loggers.LOGGER.debug("Expected setting 'usePlaintext' to be 'false', but found 'true'.");
            }
            return builder.audience(String.format("%s.%s", ZEEBE_DOMAIN_COMPONENT, this.domain)).clientId(this.clientId).clientSecret(this.clientSecret).authorizationServerUrl(String.format("https://login.cloud.%s/oauth/token", this.domain)).build();
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id', 'client id' and 'client secret' to set credentials provider in the client cloud builder, but overwriting with explicitly defined credentials provider.");
        return provider;
    }

    private boolean isNeedToSetCloudGrpcAddress() {
        return this.innerBuilder.getGrpcAddress() == null || Objects.equals(this.innerBuilder.getGrpcAddress(), ZeebeClientBuilderImpl.DEFAULT_GRPC_ADDRESS);
    }

    private boolean isNeedToSetCloudGatewayAddress() {
        return this.innerBuilder.getGatewayAddress() == null || Objects.equals(this.innerBuilder.getGatewayAddress(), "0.0.0.0:26500");
    }

    private boolean isNeedToSetCloudRestAddress() {
        return this.innerBuilder.getRestAddress() == null || Objects.equals(this.innerBuilder.getRestAddress(), ZeebeClientBuilderImpl.DEFAULT_REST_ADDRESS);
    }

    private URI getURIFromString(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse URI string", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.innerBuilder.toString());
        BuilderUtils.appendProperty(sb, "clusterId", this.clusterId);
        BuilderUtils.appendProperty(sb, "clientId", this.clientId);
        BuilderUtils.appendProperty(sb, "region", this.region);
        return sb.toString();
    }
}

