/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.EvaluateDecisionCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.EvaluateDecisionResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.EvaluateDecisionResponseImpl;
import io.camunda.zeebe.client.impl.util.ParseUtil;
import io.camunda.zeebe.client.protocol.rest.DecisionEvaluationInstruction;
import io.camunda.zeebe.client.protocol.rest.EvaluateDecisionResult;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

@Deprecated
public class EvaluateDecisionCommandImpl
extends CommandWithVariables<EvaluateDecisionCommandImpl>
implements EvaluateDecisionCommandStep1,
EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.EvaluateDecisionRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final JsonMapper jsonMapper;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final DecisionEvaluationInstruction httpRequestObject;
    private boolean useRest;

    public EvaluateDecisionCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, ZeebeClientConfiguration config, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.jsonMapper = jsonMapper;
        this.grpcRequestObjectBuilder = GatewayOuterClass.EvaluateDecisionRequest.newBuilder();
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new DecisionEvaluationInstruction();
        this.useRest = config.preferRestOverGrpc();
        this.tenantId(config.getDefaultTenantId());
        this.requestTimeout(this.requestTimeout);
    }

    @Deprecated
    public EvaluateDecisionCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.jsonMapper = jsonMapper;
        this.requestTimeout = requestTimeout;
        this.grpcRequestObjectBuilder = GatewayOuterClass.EvaluateDecisionRequest.newBuilder();
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new DecisionEvaluationInstruction();
        this.tenantId("<default>");
        this.requestTimeout(requestTimeout);
    }

    @Override
    protected EvaluateDecisionCommandImpl setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.jsonMapper.fromJsonAsMap(variables));
        }
        return this;
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 decisionId(String decisionId) {
        this.grpcRequestObjectBuilder.setDecisionId(decisionId);
        this.httpRequestObject.setDecisionDefinitionId(decisionId);
        return this;
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 decisionKey(long decisionKey) {
        this.grpcRequestObjectBuilder.setDecisionKey(decisionKey);
        this.httpRequestObject.setDecisionDefinitionKey(ParseUtil.keyToString(decisionKey));
        return this;
    }

    @Override
    public FinalCommandStep<EvaluateDecisionResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<EvaluateDecisionResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<EvaluateDecisionResponse> sendRestRequest() {
        HttpZeebeFuture<EvaluateDecisionResponse> result = new HttpZeebeFuture<EvaluateDecisionResponse>();
        this.httpClient.post("/decision-definitions/evaluation", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), EvaluateDecisionResult.class, response -> new EvaluateDecisionResponseImpl((EvaluateDecisionResult)response, this.jsonMapper), result);
        return result;
    }

    private ZeebeFuture<EvaluateDecisionResponse> sendGrpcRequest() {
        GatewayOuterClass.EvaluateDecisionRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<EvaluateDecisionResponse, GatewayOuterClass.EvaluateDecisionResponse> future = new RetriableClientFutureImpl<EvaluateDecisionResponse, GatewayOuterClass.EvaluateDecisionResponse>(gatewayResponse -> new EvaluateDecisionResponseImpl(this.jsonMapper, (GatewayOuterClass.EvaluateDecisionResponse)gatewayResponse), this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.EvaluateDecisionResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.EvaluateDecisionResponse>)future);
        return future;
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 tenantId(String tenantId) {
        this.grpcRequestObjectBuilder.setTenantId(tenantId);
        this.httpRequestObject.setTenantId(tenantId);
        return this;
    }

    private void sendGrpcRequest(GatewayOuterClass.EvaluateDecisionRequest request, StreamObserver<GatewayOuterClass.EvaluateDecisionResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).evaluateDecision(request, streamObserver);
    }

    @Override
    public EvaluateDecisionCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public EvaluateDecisionCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

