/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "description", "roleId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RoleUpdateResult {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_ROLE_ID = "roleId";
    @Nullable
    private String roleId;

    public RoleUpdateResult name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public RoleUpdateResult description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public RoleUpdateResult roleId(@Nullable String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Nullable
    @JsonProperty(value="roleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoleId() {
        return this.roleId;
    }

    @JsonProperty(value="roleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleId(@Nullable String roleId) {
        this.roleId = roleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleUpdateResult roleUpdateResult = (RoleUpdateResult)o;
        return Objects.equals(this.name, roleUpdateResult.name) && Objects.equals(this.description, roleUpdateResult.description) && Objects.equals(this.roleId, roleUpdateResult.roleId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.roleId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleUpdateResult {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    roleId: ").append(this.toIndentedString(this.roleId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRoleId() != null) {
            try {
                joiner.add(String.format("%sroleId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoleId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

