/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CommandWrapper {
    private final FinalCommandStep<Void> command;
    private final ActivatedJob job;
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private long currentRetryDelay = 50L;
    private int invocationCounter = 0;
    private final int maxRetries = 20;

    public CommandWrapper(FinalCommandStep<Void> command, ActivatedJob job, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy) {
        this.command = command;
        this.job = job;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
    }

    public void executeAsync() {
        ++this.invocationCounter;
        this.command.send().exceptionally(t -> {
            this.commandExceptionHandlingStrategy.handleCommandError(this, (Throwable)t);
            return null;
        });
    }

    public void increaseBackoffUsing(BackoffSupplier backoffSupplier) {
        this.currentRetryDelay = backoffSupplier.supplyRetryDelay(this.currentRetryDelay);
    }

    public void scheduleExecutionUsing(ScheduledExecutorService scheduledExecutorService) {
        scheduledExecutorService.schedule(this::executeAsync, this.currentRetryDelay, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "{command=" + String.valueOf(this.command.getClass()) + ", job=" + String.valueOf(this.job) + ", currentRetryDelay=" + this.currentRetryDelay + "}";
    }

    public boolean hasMoreRetries() {
        if (this.jobDeadlineExceeded()) {
            return false;
        }
        return this.invocationCounter < 20;
    }

    private boolean jobDeadlineExceeded() {
        return Instant.now().getEpochSecond() > this.job.getDeadline();
    }
}

