/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationModifier;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationUpdateNotifier;
import io.camunda.zeebe.dynamic.config.PersistedClusterConfiguration;
import io.camunda.zeebe.dynamic.config.StaticConfiguration;
import io.camunda.zeebe.dynamic.config.serializer.ClusterConfigurationSerializer;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClusterConfigurationInitializer {
    public static final Logger LOG = LoggerFactory.getLogger(ClusterConfigurationInitializer.class);

    public ActorFuture<ClusterConfiguration> initialize();

    default public ClusterConfigurationInitializer orThen(ClusterConfigurationInitializer after) {
        ClusterConfigurationInitializer actual = this;
        return () -> {
            CompletableActorFuture chainedInitialize = new CompletableActorFuture();
            actual.initialize().onComplete((arg_0, arg_1) -> ClusterConfigurationInitializer.lambda$orThen$0((ActorFuture)chainedInitialize, after, arg_0, arg_1));
            return chainedInitialize;
        };
    }

    default public ClusterConfigurationInitializer andThen(ClusterConfigurationModifier modifier) {
        ClusterConfigurationInitializer actual = this;
        return () -> {
            CompletableActorFuture chainedInitialize = new CompletableActorFuture();
            actual.initialize().onComplete((arg_0, arg_1) -> ClusterConfigurationInitializer.lambda$andThen$2((ActorFuture)chainedInitialize, modifier, arg_0, arg_1));
            return chainedInitialize;
        };
    }

    default public ClusterConfigurationInitializer recover(Class<? extends InitializerError> exception, ClusterConfigurationInitializer recovery) {
        ClusterConfigurationInitializer actual = this;
        return () -> {
            CompletableActorFuture chainedInitialize = new CompletableActorFuture();
            actual.initialize().onComplete((arg_0, arg_1) -> ClusterConfigurationInitializer.lambda$recover$4(exception, recovery, (ActorFuture)chainedInitialize, arg_0, arg_1));
            return chainedInitialize;
        };
    }

    private static /* synthetic */ void lambda$recover$4(Class exception, ClusterConfigurationInitializer recovery, ActorFuture chainedInitialize, ClusterConfiguration configuration, Throwable error) {
        if (error != null && exception.isAssignableFrom(error.getClass())) {
            LOG.warn("Recovering from {} by falling back to {}", (Object)error, (Object)recovery);
            recovery.initialize().onComplete((BiConsumer)chainedInitialize);
        } else if (error != null) {
            chainedInitialize.completeExceptionally(error);
        } else {
            chainedInitialize.complete((Object)configuration);
        }
    }

    private static /* synthetic */ void lambda$andThen$2(ActorFuture chainedInitialize, ClusterConfigurationModifier modifier, ClusterConfiguration configuration, Throwable error) {
        if (error != null) {
            LOG.error("Failed to initialize configuration", error);
            chainedInitialize.completeExceptionally(error);
        } else if (configuration.isUninitialized()) {
            chainedInitialize.complete((Object)configuration);
        } else {
            modifier.modify(configuration).onComplete((BiConsumer)chainedInitialize);
        }
    }

    private static /* synthetic */ void lambda$orThen$0(ActorFuture chainedInitialize, ClusterConfigurationInitializer after, ClusterConfiguration configuration, Throwable error) {
        if (error != null) {
            LOG.error("Failed to initialize configuration", error);
            chainedInitialize.completeExceptionally(error);
        } else if (configuration.isUninitialized()) {
            after.initialize().onComplete((BiConsumer)chainedInitialize);
        } else {
            chainedInitialize.complete((Object)configuration);
        }
    }

    public static sealed interface InitializerError {

        public static final class PersistedConfigurationIsBroken
        extends RuntimeException
        implements InitializerError {
            public PersistedConfigurationIsBroken(Path file, Throwable cause) {
                super("File %s is corrupted".formatted(file), cause);
            }
        }
    }

    public static class StaticInitializer
    implements ClusterConfigurationInitializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(StaticInitializer.class);
        private final StaticConfiguration staticConfiguration;

        public StaticInitializer(StaticConfiguration staticConfiguration) {
            this.staticConfiguration = staticConfiguration;
        }

        @Override
        public ActorFuture<ClusterConfiguration> initialize() {
            try {
                ClusterConfiguration configuration = this.staticConfiguration.generateTopology();
                LOGGER.debug("Generated cluster configuration from provided configuration. {}", (Object)configuration);
                return CompletableActorFuture.completed((Object)configuration);
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)e);
            }
        }
    }

    public static class SyncInitializer
    implements ClusterConfigurationInitializer,
    ClusterConfigurationUpdateNotifier.ClusterConfigurationUpdateListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(SyncInitializer.class);
        private static final Duration SYNC_QUERY_RETRY_DELAY = Duration.ofSeconds(5L);
        private final ClusterConfigurationUpdateNotifier clusterConfigurationUpdateNotifier;
        private final ActorFuture<ClusterConfiguration> initialized;
        private final List<MemberId> knownMembersToSync;
        private final ConcurrencyControl executor;
        private final Function<MemberId, ActorFuture<ClusterConfiguration>> syncRequester;

        public SyncInitializer(ClusterConfigurationUpdateNotifier clusterConfigurationUpdateNotifier, List<MemberId> knownMembersToSync, ConcurrencyControl executor, Function<MemberId, ActorFuture<ClusterConfiguration>> syncRequester) {
            this.clusterConfigurationUpdateNotifier = clusterConfigurationUpdateNotifier;
            this.knownMembersToSync = knownMembersToSync;
            this.executor = executor;
            this.syncRequester = syncRequester;
            this.initialized = new CompletableActorFuture();
        }

        @Override
        public ActorFuture<ClusterConfiguration> initialize() {
            if (this.knownMembersToSync.isEmpty()) {
                this.initialized.complete((Object)ClusterConfiguration.uninitialized());
            } else {
                LOGGER.debug("Querying members {} before initializing ClusterConfiguration", this.knownMembersToSync);
                this.clusterConfigurationUpdateNotifier.addUpdateListener(this);
                this.knownMembersToSync.forEach(this::tryInitializeFrom);
            }
            return this.initialized;
        }

        private void tryInitializeFrom(MemberId memberId) {
            this.requestSync(memberId).onComplete((configuration, error) -> {
                if (this.initialized.isDone()) {
                    return;
                }
                if (error != null) {
                    LOGGER.trace("Failed to get a response for cluster configuration sync query to {}. Will retry.", (Object)memberId, error);
                } else if (configuration == null) {
                    LOGGER.trace("Received null cluster configuration from {}. Will retry.", (Object)memberId);
                } else {
                    if (configuration.isUninitialized()) {
                        LOGGER.trace("Cluster configuration is uninitialized in {}", (Object)memberId);
                        this.initialized.complete(configuration);
                        return;
                    }
                    LOGGER.debug("Received cluster configuration {} from {}", configuration, (Object)memberId);
                    this.onClusterConfigurationUpdated((ClusterConfiguration)configuration);
                    return;
                }
                if (!this.initialized.isDone()) {
                    this.executor.schedule(SYNC_QUERY_RETRY_DELAY, () -> this.tryInitializeFrom(memberId));
                }
            });
        }

        private ActorFuture<ClusterConfiguration> requestSync(MemberId memberId) {
            return this.syncRequester.apply(memberId);
        }

        @Override
        public void onClusterConfigurationUpdated(ClusterConfiguration clusterConfiguration) {
            this.executor.run(() -> {
                if (this.initialized.isDone()) {
                    return;
                }
                if (!clusterConfiguration.isUninitialized()) {
                    this.initialized.complete((Object)clusterConfiguration);
                    this.clusterConfigurationUpdateNotifier.removeUpdateListener(this);
                }
            });
        }
    }

    public static class GossipInitializer
    implements ClusterConfigurationInitializer,
    ClusterConfigurationUpdateNotifier.ClusterConfigurationUpdateListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(GossipInitializer.class);
        private final ClusterConfigurationUpdateNotifier clusterConfigurationUpdateNotifier;
        private final PersistedClusterConfiguration persistedClusterConfiguration;
        private final Consumer<ClusterConfiguration> configurationGossiper;
        private final ActorFuture<ClusterConfiguration> initialized;
        private final ConcurrencyControl executor;

        public GossipInitializer(ClusterConfigurationUpdateNotifier clusterConfigurationUpdateNotifier, PersistedClusterConfiguration persistedClusterConfiguration, Consumer<ClusterConfiguration> configurationGossiper, ConcurrencyControl executor) {
            this.clusterConfigurationUpdateNotifier = clusterConfigurationUpdateNotifier;
            this.persistedClusterConfiguration = persistedClusterConfiguration;
            this.configurationGossiper = configurationGossiper;
            this.executor = executor;
            this.initialized = new CompletableActorFuture();
        }

        @Override
        public ActorFuture<ClusterConfiguration> initialize() {
            LOGGER.debug("Waiting for initial cluster configuration via gossip.");
            this.clusterConfigurationUpdateNotifier.addUpdateListener(this);
            if (this.persistedClusterConfiguration.isUninitialized()) {
                this.configurationGossiper.accept(this.persistedClusterConfiguration.getConfiguration());
            }
            return this.initialized;
        }

        @Override
        public void onClusterConfigurationUpdated(ClusterConfiguration clusterConfiguration) {
            this.executor.run(() -> {
                if (this.initialized.isDone()) {
                    return;
                }
                if (!clusterConfiguration.isUninitialized()) {
                    LOGGER.debug("Received cluster configuration {} via gossip.", (Object)clusterConfiguration);
                    this.initialized.complete((Object)clusterConfiguration);
                    this.clusterConfigurationUpdateNotifier.removeUpdateListener(this);
                }
            });
        }
    }

    public static class FileInitializer
    implements ClusterConfigurationInitializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(FileInitializer.class);
        private final Path configurationFile;
        private final ClusterConfigurationSerializer serializer;

        public FileInitializer(Path configurationFile, ClusterConfigurationSerializer serializer) {
            this.configurationFile = configurationFile;
            this.serializer = serializer;
        }

        @Override
        public ActorFuture<ClusterConfiguration> initialize() {
            try {
                ClusterConfiguration persistedTopology = PersistedClusterConfiguration.ofFile(this.configurationFile, this.serializer).getConfiguration();
                if (!persistedTopology.isUninitialized()) {
                    LOGGER.debug("Initialized cluster configuration '{}' from file '{}'", (Object)persistedTopology, (Object)this.configurationFile);
                }
                return CompletableActorFuture.completed((Object)persistedTopology);
            }
            catch (Exception e) {
                return CompletableActorFuture.completedExceptionally((Throwable)new InitializerError.PersistedConfigurationIsBroken(this.configurationFile, (Throwable)e));
            }
        }
    }
}

