/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationModifier;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.ExporterState;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExporterStateInitializer
implements ClusterConfigurationModifier {
    private final Set<String> configuredExporters;
    private final MemberId localMemberId;
    private final ConcurrencyControl executor;

    public ExporterStateInitializer(Set<String> configuredExporters, MemberId localMemberId, ConcurrencyControl executor) {
        this.configuredExporters = configuredExporters;
        this.localMemberId = localMemberId;
        this.executor = executor;
    }

    @Override
    public ActorFuture<ClusterConfiguration> modify(ClusterConfiguration configuration) {
        ActorFuture result = this.executor.createFuture();
        if (!configuration.hasMember(this.localMemberId)) {
            result.complete((Object)configuration);
        } else {
            result.complete((Object)configuration.updateMember(this.localMemberId, this::updateExporterState));
        }
        return result;
    }

    private MemberState updateExporterState(MemberState memberState) {
        MemberState updatedMemberState = memberState;
        for (Integer p : memberState.partitions().keySet()) {
            PartitionState currentPartitionState = memberState.partitions().get(p);
            PartitionState updatedPartitionState = this.updateExporterStateInPartition(currentPartitionState);
            if (updatedPartitionState.equals(currentPartitionState)) continue;
            updatedMemberState = updatedMemberState.updatePartition(p, partitionState -> updatedPartitionState);
        }
        return updatedMemberState;
    }

    private PartitionState updateExporterStateInPartition(PartitionState partitionState) {
        PartitionState initializedPartitionState = partitionState.config().isInitialized() ? partitionState : new PartitionState(partitionState.state(), partitionState.priority(), DynamicPartitionConfig.init());
        Map<String, ExporterState> exportersInConfig = initializedPartitionState.config().exporting().exporters();
        List<String> newlyAddedExporters = this.configuredExporters.stream().filter(id -> !exportersInConfig.containsKey(id)).toList();
        List<String> removedExporters = exportersInConfig.keySet().stream().filter(id -> !this.configuredExporters.contains(id)).toList();
        return initializedPartitionState.updateConfig(c -> c.updateExporting(e -> e.disableExporters(removedExporters))).updateConfig(c -> c.updateExporting(e -> e.addExporters(newlyAddedExporters)));
    }
}

