/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationUpdateNotifier;
import io.camunda.zeebe.dynamic.config.gossip.ClusterConfigurationGossiper;
import io.camunda.zeebe.dynamic.config.gossip.ClusterConfigurationGossiperConfig;
import io.camunda.zeebe.dynamic.config.serializer.ProtoBufSerializer;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayClusterConfigurationService
extends Actor
implements ClusterConfigurationUpdateNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(GatewayClusterConfigurationService.class);
    private final ClusterConfigurationGossiper clusterConfigurationGossiper;
    private ClusterConfiguration clusterConfiguration = ClusterConfiguration.uninitialized();

    public GatewayClusterConfigurationService(ClusterCommunicationService communicationService, ClusterMembershipService memberShipService, ClusterConfigurationGossiperConfig config) {
        this.clusterConfigurationGossiper = new ClusterConfigurationGossiper((ConcurrencyControl)this, communicationService, memberShipService, new ProtoBufSerializer(), config, this::updateClusterTopology);
    }

    private void updateClusterTopology(ClusterConfiguration clusterConfiguration) {
        this.actor.run(() -> {
            if (clusterConfiguration == null || clusterConfiguration.isUninitialized()) {
                return;
            }
            try {
                ClusterConfiguration mergedTopology = this.clusterConfiguration.merge(clusterConfiguration);
                if (mergedTopology.equals(this.clusterConfiguration)) {
                    return;
                }
                LOG.debug("Received new configuration {}. Updating local configuration to {}", (Object)clusterConfiguration, (Object)mergedTopology);
                this.clusterConfiguration = mergedTopology;
                this.clusterConfigurationGossiper.updateClusterConfiguration(this.clusterConfiguration);
            }
            catch (Exception updateFailed) {
                LOG.warn("Failed to process received configuration update {}", (Object)clusterConfiguration, (Object)updateFailed);
            }
        });
    }

    protected void onActorStarting() {
        this.clusterConfigurationGossiper.start();
    }

    protected void onActorClosing() {
        this.clusterConfigurationGossiper.close();
    }

    @Override
    public void addUpdateListener(ClusterConfigurationUpdateNotifier.ClusterConfigurationUpdateListener listener) {
        this.clusterConfigurationGossiper.addUpdateListener(listener);
    }

    @Override
    public void removeUpdateListener(ClusterConfigurationUpdateNotifier.ClusterConfigurationUpdateListener listener) {
        this.clusterConfigurationGossiper.removeUpdateListener(listener);
    }
}

