/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config;

import io.camunda.zeebe.dynamic.config.ClusterConfigurationModifier;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.util.Optional;

public class RoutingStateInitializer
implements ClusterConfigurationModifier {
    private final boolean enablePartitionScaling;
    private final int staticPartitionCount;

    public RoutingStateInitializer(boolean enablePartitionScaling, int staticPartitionCount) {
        this.enablePartitionScaling = enablePartitionScaling;
        this.staticPartitionCount = staticPartitionCount;
    }

    @Override
    public ActorFuture<ClusterConfiguration> modify(ClusterConfiguration configuration) {
        if (configuration.routingState().isPresent() || !this.enablePartitionScaling) {
            return CompletableActorFuture.completed((Object)configuration);
        }
        RoutingState routingState = RoutingState.initializeWithPartitionCount(this.staticPartitionCount);
        ClusterConfiguration withRoutingState = new ClusterConfiguration(configuration.version(), configuration.members(), configuration.lastChange(), configuration.pendingChanges(), Optional.of(routingState));
        return CompletableActorFuture.completed((Object)withRoutingState);
    }
}

