/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.dynamic.config.PartitionDistributor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.util.ConfigurationUtil;
import java.util.List;
import java.util.Set;

public record StaticConfiguration(boolean enablePartitionScaling, PartitionDistributor partitionDistributor, Set<MemberId> clusterMembers, MemberId localMemberId, List<PartitionId> partitionIds, int replicationFactor, DynamicPartitionConfig partitionConfig) {
    public int partitionCount() {
        return this.partitionIds.size();
    }

    public ClusterConfiguration generateTopology() {
        Set<PartitionMetadata> partitionDistribution = this.generatePartitionDistribution();
        return ConfigurationUtil.getClusterConfigFrom(this.enablePartitionScaling, partitionDistribution, this.partitionConfig);
    }

    public Set<PartitionMetadata> generatePartitionDistribution() {
        List<PartitionId> sortedPartitionIds = this.partitionIds.stream().sorted().toList();
        return this.partitionDistributor.distributePartitions(this.clusterMembers, sortedPartitionIds, this.replicationFactor);
    }
}

