/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationChangeResponse;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationCoordinatorSupplier;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationManagementRequest;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestTopics;
import io.camunda.zeebe.dynamic.config.api.ErrorResponse;
import io.camunda.zeebe.dynamic.config.serializer.ClusterConfigurationRequestsSerializer;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.util.Either;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class ClusterConfigurationManagementRequestSender {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private final ClusterCommunicationService communicationService;
    private final ClusterConfigurationCoordinatorSupplier coordinatorSupplier;
    private final ClusterConfigurationRequestsSerializer serializer;

    public ClusterConfigurationManagementRequestSender(ClusterCommunicationService communicationService, ClusterConfigurationCoordinatorSupplier coordinatorSupplier, ClusterConfigurationRequestsSerializer serializer) {
        this.communicationService = communicationService;
        this.coordinatorSupplier = coordinatorSupplier;
        this.serializer = serializer;
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> addMembers(ClusterConfigurationManagementRequest.AddMembersRequest addMembersRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.ADD_MEMBER.topic(), (Object)addMembersRequest, this.serializer::encodeAddMembersRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> removeMembers(ClusterConfigurationManagementRequest.RemoveMembersRequest removeMembersRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.REMOVE_MEMBER.topic(), (Object)removeMembersRequest, this.serializer::encodeRemoveMembersRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> joinPartition(ClusterConfigurationManagementRequest.JoinPartitionRequest joinPartitionRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.JOIN_PARTITION.topic(), (Object)joinPartitionRequest, this.serializer::encodeJoinPartitionRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> leavePartition(ClusterConfigurationManagementRequest.LeavePartitionRequest leavePartitionRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.LEAVE_PARTITION.topic(), (Object)leavePartitionRequest, this.serializer::encodeLeavePartitionRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> reassignPartitions(ClusterConfigurationManagementRequest.ReassignPartitionsRequest reassignPartitionsRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.REASSIGN_PARTITIONS.topic(), (Object)reassignPartitionsRequest, this.serializer::encodeReassignPartitionsRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> scaleMembers(ClusterConfigurationManagementRequest.BrokerScaleRequest scaleRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.SCALE_MEMBERS.topic(), (Object)scaleRequest, this.serializer::encodeScaleRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> forceScaleDown(ClusterConfigurationManagementRequest.BrokerScaleRequest forceScaleDownRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.FORCE_SCALE_DOWN.topic(), (Object)forceScaleDownRequest, this.serializer::encodeScaleRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getNextCoordinator(forceScaleDownRequest.members()), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> scaleCluster(ClusterConfigurationManagementRequest.ClusterScaleRequest clusterScaleRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.SCALE_CLUSTER.topic(), (Object)clusterScaleRequest, this.serializer::encodeClusterScaleRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> patchCluster(ClusterConfigurationManagementRequest.ClusterPatchRequest clusterPatchRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.PATCH_CLUSTER.topic(), (Object)clusterPatchRequest, this.serializer::encodeClusterPatchRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> forceRemoveBrokers(ClusterConfigurationManagementRequest.ForceRemoveBrokersRequest forceRemoveBrokersRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.FORCE_REMOVE_BROKERS.topic(), (Object)forceRemoveBrokersRequest, this.serializer::encodeForceRemoveBrokersRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getNextCoordinatorExcluding(forceRemoveBrokersRequest.membersToRemove()), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> disableExporter(ClusterConfigurationManagementRequest.ExporterDisableRequest exporterDisableRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.DISABLE_EXPORTER.topic(), (Object)exporterDisableRequest, this.serializer::encodeExporterDisableRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> enableExporter(ClusterConfigurationManagementRequest.ExporterEnableRequest enableRequest) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.ENABLE_EXPORTER.topic(), (Object)enableRequest, this.serializer::encodeExporterEnableRequest, this.serializer::decodeTopologyChangeResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfiguration>> getTopology() {
        return this.communicationService.send(ClusterConfigurationRequestTopics.QUERY_TOPOLOGY.topic(), (Object)new byte[0], Function.identity(), this.serializer::decodeClusterTopologyResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }

    public CompletableFuture<Either<ErrorResponse, ClusterConfiguration>> cancelTopologyChange(ClusterConfigurationManagementRequest.CancelChangeRequest request) {
        return this.communicationService.send(ClusterConfigurationRequestTopics.CANCEL_CHANGE.topic(), (Object)request, this.serializer::encodeCancelChangeRequest, this.serializer::decodeClusterTopologyResponse, this.coordinatorSupplier.getDefaultCoordinator(), TIMEOUT);
    }
}

