/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ExporterDisableRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final String exporterId;

    public ExporterDisableRequestTransformer(String exporterId) {
        this.exporterId = exporterId;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        ArrayList<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation> operations = new ArrayList<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation>();
        for (Map.Entry<MemberId, MemberState> member : clusterConfiguration.members().entrySet()) {
            MemberId memberId = member.getKey();
            for (Map.Entry<Integer, PartitionState> partitions : member.getValue().partitions().entrySet()) {
                Integer partitionId = partitions.getKey();
                operations.add(new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation(memberId, partitionId, this.exporterId));
            }
        }
        return Either.right(operations);
    }
}

