/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.api.ForceScaleDownRequestTransformer;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ForceRemoveBrokersRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final Set<MemberId> membersToRemove;
    private final MemberId coordinator;

    public ForceRemoveBrokersRequestTransformer(Set<MemberId> membersToRemove, MemberId coordinator) {
        this.membersToRemove = membersToRemove;
        this.coordinator = coordinator;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        HashSet<MemberId> membersToRetain = new HashSet<MemberId>(clusterConfiguration.members().keySet());
        membersToRetain.removeAll(this.membersToRemove);
        return new ForceScaleDownRequestTransformer(membersToRetain, this.coordinator).operations(clusterConfiguration);
    }

    @Override
    public boolean isForced() {
        return true;
    }
}

