/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestFailedException;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ForceScaleDownRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final Set<MemberId> membersToRetain;
    private final MemberId coordinator;

    public ForceScaleDownRequestTransformer(Set<MemberId> membersToRetain, MemberId coordinator) {
        this.membersToRetain = membersToRetain;
        this.coordinator = coordinator;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        for (MemberId member : this.membersToRetain) {
            if (clusterConfiguration.hasMember(member)) continue;
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(String.format("Expected to force configure while retaining broker '%s', but broker '%s' is not in the current cluster. Current members are '%s'", member, member, clusterConfiguration.members().keySet())));
        }
        List<Integer> partitions = clusterConfiguration.members().values().stream().map(MemberState::partitions).flatMap(p -> p.keySet().stream()).distinct().toList();
        Map<Integer, ArrayList<MemberId>> partitionsWithNewMembers = this.calculateNewConfiguration(clusterConfiguration, this.membersToRetain, partitions);
        List<Integer> partitionsWithNoReplicas = partitions.stream().filter(p -> !partitionsWithNewMembers.containsKey(p) || ((ArrayList)partitionsWithNewMembers.get(p)).isEmpty()).toList();
        boolean hasReplicasForAllPartitions = partitionsWithNoReplicas.isEmpty();
        if (!hasReplicasForAllPartitions) {
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(String.format("Expected to force configure and retain members '%s', but this will result in partitions '%s' having no replicas", this.membersToRetain, partitionsWithNoReplicas)));
        }
        List<MemberId> memberToRemove = clusterConfiguration.members().keySet().stream().filter(m -> !this.membersToRetain.contains(m)).toList();
        return this.generateOperations(partitionsWithNewMembers, memberToRemove);
    }

    @Override
    public boolean isForced() {
        return true;
    }

    private Either<Exception, List<ClusterConfigurationChangeOperation>> generateOperations(Map<Integer, ArrayList<MemberId>> partitionsWithNewMembers, List<MemberId> memberToRemove) {
        List<ClusterConfigurationChangeOperation> partitionForceConfigureOperations = this.reconfigurePartitions(partitionsWithNewMembers);
        ArrayList<ClusterConfigurationChangeOperation> operations = new ArrayList<ClusterConfigurationChangeOperation>(partitionForceConfigureOperations);
        List<ClusterConfigurationChangeOperation> memberRemoveOperations = this.forceRemoveMembers(memberToRemove);
        operations.addAll(memberRemoveOperations);
        return Either.right(operations);
    }

    private List<ClusterConfigurationChangeOperation> reconfigurePartitions(Map<Integer, ArrayList<MemberId>> partitionsWithNewMembers) {
        return partitionsWithNewMembers.entrySet().stream().map(partition -> new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation((MemberId)((ArrayList)partition.getValue()).stream().findFirst().orElseThrow(), (Integer)partition.getKey(), (Collection)partition.getValue())).map(ClusterConfigurationChangeOperation.class::cast).toList();
    }

    private List<ClusterConfigurationChangeOperation> forceRemoveMembers(List<MemberId> membersToRemove) {
        return membersToRemove.stream().map(member -> new ClusterConfigurationChangeOperation.MemberRemoveOperation(this.coordinator, (MemberId)member)).map(ClusterConfigurationChangeOperation.class::cast).toList();
    }

    private Map<Integer, ArrayList<MemberId>> calculateNewConfiguration(ClusterConfiguration currentTopology, Set<MemberId> membersToRetain, List<Integer> partitions) {
        HashMap<Integer, ArrayList<MemberId>> partitionToMembersMap = new HashMap<Integer, ArrayList<MemberId>>();
        for (Integer partitionId : partitions) {
            partitionToMembersMap.put(partitionId, new ArrayList());
            for (MemberId member : membersToRetain) {
                if (!currentTopology.getMember(member).hasPartition(partitionId)) continue;
                partitionToMembersMap.computeIfPresent(partitionId, (ignore, members) -> {
                    members.add(member);
                    return members;
                });
            }
        }
        return partitionToMembersMap;
    }
}

