/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestFailedException;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.util.ConfigurationUtil;
import io.camunda.zeebe.dynamic.config.util.RoundRobinPartitionDistributor;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

public class PartitionReassignRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    final Set<MemberId> members;
    private final Optional<Integer> newReplicationFactor;
    private final Optional<Integer> newPartitionCount;

    public PartitionReassignRequestTransformer(Set<MemberId> members, Optional<Integer> newReplicationFactor, Optional<Integer> newPartitionCount) {
        this.members = members;
        this.newReplicationFactor = newReplicationFactor;
        this.newPartitionCount = newPartitionCount;
    }

    public PartitionReassignRequestTransformer(Set<MemberId> members) {
        this(members, Optional.empty(), Optional.empty());
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        if (this.members.isEmpty()) {
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(new IllegalArgumentException("Cannot reassign partitions if no brokers are provided")));
        }
        return this.generatePartitionDistributionOperations(clusterConfiguration, this.members);
    }

    private int getReplicationFactor(ClusterConfiguration clusterConfiguration) {
        return this.newReplicationFactor.orElse(clusterConfiguration.minReplicationFactor());
    }

    private int getPartitionCount(ClusterConfiguration clusterConfiguration) {
        return this.newPartitionCount.orElse(clusterConfiguration.partitionCount());
    }

    private Either<Exception, List<ClusterConfigurationChangeOperation>> generatePartitionDistributionOperations(ClusterConfiguration currentConfiguration, Set<MemberId> brokers) {
        ArrayList operations = new ArrayList();
        Set<PartitionMetadata> oldDistribution = ConfigurationUtil.getPartitionDistributionFrom(currentConfiguration, "temp");
        int partitionCount = this.getPartitionCount(currentConfiguration);
        if (partitionCount < currentConfiguration.partitionCount()) {
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(String.format("New partition count [%d] must be greater than or equal to the current partition count [%d]", partitionCount, currentConfiguration.partitionCount())));
        }
        int replicationFactor = this.getReplicationFactor(currentConfiguration);
        if (replicationFactor <= 0) {
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(String.format("Replication factor [%d] must be greater than 0", replicationFactor)));
        }
        if (brokers.size() < replicationFactor) {
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(String.format("Number of brokers [%d] is less than the replication factor [%d]", brokers.size(), replicationFactor)));
        }
        List<PartitionId> sortedPartitions = IntStream.rangeClosed(1, partitionCount).mapToObj(i -> PartitionId.from((String)"temp", (int)i)).sorted().toList();
        RoundRobinPartitionDistributor roundRobinDistributor = new RoundRobinPartitionDistributor();
        Set<PartitionMetadata> newDistribution = roundRobinDistributor.distributePartitions(brokers, sortedPartitions, replicationFactor);
        List<PartitionMetadata> sortedPartitionMetadata = newDistribution.stream().sorted(Comparator.comparingInt(p -> (Integer)p.id().id())).toList();
        for (PartitionMetadata newMetadata : sortedPartitionMetadata) {
            oldDistribution.stream().filter(old -> ((Integer)old.id().id()).equals(newMetadata.id().id())).findFirst().ifPresentOrElse(oldMetadata -> operations.addAll(this.movePartition((PartitionMetadata)oldMetadata, newMetadata)), () -> operations.addAll(this.addPartition(newMetadata)));
        }
        return Either.right(operations);
    }

    private List<ClusterConfigurationChangeOperation> addPartition(PartitionMetadata newMetadata) {
        Integer partitionId = (Integer)newMetadata.id().id();
        ArrayList<ClusterConfigurationChangeOperation> operations = new ArrayList<ClusterConfigurationChangeOperation>();
        MemberId primary = newMetadata.getPrimary().orElse((MemberId)newMetadata.members().stream().findAny().orElseThrow());
        operations.add(new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation(primary, partitionId, newMetadata.getPriority(primary)));
        for (MemberId member : newMetadata.members()) {
            if (member.equals((Object)primary)) continue;
            operations.add(new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation(member, partitionId, newMetadata.getPriority(member)));
        }
        return operations;
    }

    private List<ClusterConfigurationChangeOperation> movePartition(PartitionMetadata oldMetadata, PartitionMetadata newMetadata) {
        Integer partitionId = (Integer)newMetadata.id().id();
        ArrayList<ClusterConfigurationChangeOperation> operations = new ArrayList<ClusterConfigurationChangeOperation>();
        List<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation> membersToJoin = newMetadata.members().stream().filter(member -> !oldMetadata.members().contains(member)).map(newMember -> new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation((MemberId)newMember, partitionId, newMetadata.getPriority(newMember))).toList();
        List<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation> membersToLeave = oldMetadata.members().stream().filter(member -> !newMetadata.members().contains(member)).map(oldMember -> new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation((MemberId)oldMember, partitionId)).toList();
        List<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation> membersToChangePriority = oldMetadata.members().stream().filter(memberId -> newMetadata.members().contains(memberId)).filter(memberId -> newMetadata.getPriority(memberId) != oldMetadata.getPriority(memberId)).map(memberId -> new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation((MemberId)memberId, partitionId, newMetadata.getPriority(memberId))).toList();
        operations.addAll(membersToJoin);
        operations.addAll(membersToLeave);
        operations.addAll(membersToChangePriority);
        return operations;
    }
}

