/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ClusterMembershipChangeExecutor;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

final class MemberJoinApplier
implements ConfigurationChangeAppliers.MemberOperationApplier {
    private final MemberId memberId;
    private final ClusterMembershipChangeExecutor clusterMembershipChangeExecutor;

    MemberJoinApplier(MemberId memberId, ClusterMembershipChangeExecutor clusterMembershipChangeExecutor) {
        this.memberId = memberId;
        this.clusterMembershipChangeExecutor = clusterMembershipChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        if (currentClusterConfiguration.hasMember(this.memberId) && !currentClusterConfiguration.getMember(this.memberId).state().equals((Object)MemberState.State.JOINING)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to join member %s, but the member is already part of the cluster", this.memberId)));
        }
        if (currentClusterConfiguration.hasMember(this.memberId) && currentClusterConfiguration.getMember(this.memberId).state().equals((Object)MemberState.State.JOINING)) {
            return Either.right(UnaryOperator.identity());
        }
        return Either.right(ignore -> MemberState.uninitialized().toJoining());
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.clusterMembershipChangeExecutor.addBroker(this.memberId).onComplete((ignore, error) -> {
            if (error == null) {
                future.complete(MemberState::toActive);
            } else {
                future.completeExceptionally(error);
            }
        });
        return future;
    }
}

