/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ClusterMembershipChangeExecutor;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

public class MemberLeaveApplier
implements ConfigurationChangeAppliers.MemberOperationApplier {
    private final MemberId memberId;
    private final ClusterMembershipChangeExecutor clusterMembershipChangeExecutor;

    public MemberLeaveApplier(MemberId memberId, ClusterMembershipChangeExecutor clusterMembershipChangeExecutor) {
        this.memberId = memberId;
        this.clusterMembershipChangeExecutor = clusterMembershipChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        boolean hasPartitions;
        if (!currentClusterConfiguration.hasMember(this.memberId)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to remove member %s, but the member is not part of the cluster", this.memberId)));
        }
        boolean bl = hasPartitions = !currentClusterConfiguration.getMember(this.memberId).partitions().isEmpty();
        if (hasPartitions) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to remove member %s, but the member still has partitions assigned. Partitions: [%s]", this.memberId, currentClusterConfiguration.getMember(this.memberId).partitions())));
        }
        return Either.right(MemberState::toLeaving);
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.clusterMembershipChangeExecutor.removeBroker(this.memberId).onComplete((ignore, error) -> {
            if (error == null) {
                future.complete(MemberState::toLeft);
            } else {
                future.completeExceptionally(error);
            }
        });
        return future;
    }
}

