/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

public class NoopConfigurationChangeAppliers
implements ConfigurationChangeAppliers {
    @Override
    public ConfigurationChangeAppliers.MemberOperationApplier getApplier(ClusterConfigurationChangeOperation operation) {
        return new NoopApplier(operation.memberId());
    }

    public static class NoopApplier
    implements ConfigurationChangeAppliers.MemberOperationApplier {
        private final MemberId memberId;

        public NoopApplier(MemberId memberId) {
            this.memberId = memberId;
        }

        @Override
        public MemberId memberId() {
            return this.memberId;
        }

        @Override
        public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
            return Either.right(memberState -> memberState);
        }

        @Override
        public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
            return CompletableActorFuture.completed(memberState -> memberState);
        }
    }
}

