/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

final class PartitionDisableExporterApplier
implements ConfigurationChangeAppliers.MemberOperationApplier {
    private final int partitionId;
    private final MemberId memberId;
    private final String exporterId;
    private final PartitionChangeExecutor partitionChangeExecutor;

    public PartitionDisableExporterApplier(int partitionId, MemberId memberId, String exporterId, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.memberId = memberId;
        this.exporterId = exporterId;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        if (!currentClusterConfiguration.hasMember(this.memberId)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to disable exporter, but the member '%s' does not exist in the cluster", this.memberId)));
        }
        MemberState member = currentClusterConfiguration.getMember(this.memberId);
        boolean partitionExistsInLocalMember = member.hasPartition(this.partitionId);
        if (!partitionExistsInLocalMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to disable exporter, but the member '%s' does not have the partition '%s'", this.memberId, this.partitionId)));
        }
        boolean partitionHasExporter = member.getPartition(this.partitionId).config().exporting().exporters().containsKey(this.exporterId);
        if (!partitionHasExporter) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to disable exporter, but the partition '%s' does not have the exporter '%s'", this.partitionId, this.exporterId)));
        }
        return Either.right(memberstate -> memberstate);
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.disableExporter(this.partitionId, this.exporterId).onComplete((nothing, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.updatePartition(this.partitionId, partition -> partition.updateConfig(config -> this.disableExporter((DynamicPartitionConfig)config, this.exporterId))));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }

    private DynamicPartitionConfig disableExporter(DynamicPartitionConfig config, String exporterId) {
        return config.updateExporting(exporting -> exporting.disableExporter(exporterId));
    }
}

