/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.ExporterState;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;

final class PartitionEnableExporterApplier
implements ConfigurationChangeAppliers.MemberOperationApplier {
    private final int partitionId;
    private final MemberId memberId;
    private final String exporterId;
    private final Optional<String> initializeFrom;
    private final PartitionChangeExecutor partitionChangeExecutor;
    private long metadataVersionToUpdate;

    public PartitionEnableExporterApplier(int partitionId, MemberId memberId, String exporterId, Optional<String> initializeFrom, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.memberId = memberId;
        this.exporterId = exporterId;
        this.initializeFrom = initializeFrom;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        boolean partitionHasExporter;
        if (!currentClusterConfiguration.hasMember(this.memberId)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to enable exporter, but the member '%s' does not exist in the cluster", this.memberId)));
        }
        MemberState member = currentClusterConfiguration.getMember(this.memberId);
        boolean partitionExistsInLocalMember = member.hasPartition(this.partitionId);
        if (!partitionExistsInLocalMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to enable exporter, but the member '%s' does not have the partition '%s'", this.memberId, this.partitionId)));
        }
        Map<String, ExporterState> exportersInPartition = member.getPartition(this.partitionId).config().exporting().exporters();
        if (this.initializeFrom.isPresent()) {
            String otherExporterId = this.initializeFrom.orElseThrow();
            boolean partitionHasOtherExporter = exportersInPartition.containsKey(otherExporterId);
            if (!partitionHasOtherExporter) {
                return Either.left((Object)new IllegalStateException(String.format("Expected to enable exporter and initialize from exporter '%s', but the partition '%s' does not have exporter '%s'", otherExporterId, this.partitionId, otherExporterId)));
            }
            ExporterState otherExporter = exportersInPartition.get(otherExporterId);
            if (otherExporter.state() == ExporterState.State.DISABLED) {
                return Either.left((Object)new IllegalStateException(String.format("Expected to enable exporter and initialize from exporter '%s', but the exporter '%s' is disabled", otherExporterId, otherExporterId)));
            }
        }
        if ((partitionHasExporter = exportersInPartition.containsKey(this.exporterId)) && exportersInPartition.get(this.exporterId).state() == ExporterState.State.ENABLED) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to enable exporter, but the exporter '%s' is already enabled", this.exporterId)));
        }
        this.metadataVersionToUpdate = partitionHasExporter ? exportersInPartition.get(this.exporterId).metadataVersion() + 1L : 1L;
        return Either.right(memberState -> memberState);
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        ActorFuture<Void> enableFuture = this.partitionChangeExecutor.enableExporter(this.partitionId, this.exporterId, this.metadataVersionToUpdate, this.initializeFrom.orElse(null));
        enableFuture.onComplete((nothing, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.updatePartition(this.partitionId, partition -> partition.updateConfig(this::enableExporter)));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }

    private DynamicPartitionConfig enableExporter(DynamicPartitionConfig config) {
        return config.updateExporting(c -> this.initializeFrom.map(otherExporterId -> c.enableExporter(this.exporterId, (String)otherExporterId, this.metadataVersionToUpdate)).orElse(c.enableExporter(this.exporterId, this.metadataVersionToUpdate)));
    }
}

