/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.Collection;
import java.util.function.UnaryOperator;

final class PartitionForceReconfigureApplier
implements ConfigurationChangeAppliers.ClusterOperationApplier {
    private final int partitionId;
    private final MemberId memberId;
    private final Collection<MemberId> members;
    private final PartitionChangeExecutor partitionChangeExecutor;

    public PartitionForceReconfigureApplier(int partitionId, MemberId memberId, Collection<MemberId> members, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.memberId = memberId;
        this.members = members;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public Either<Exception, UnaryOperator<ClusterConfiguration>> init(ClusterConfiguration currentClusterConfiguration) {
        if (this.members.isEmpty()) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to reconfigure partition '%d' via member '%s', but the new configuration is empty", this.partitionId, this.memberId)));
        }
        if (!this.members.contains(this.memberId)) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to reconfigure partition '%d' via member '%s', but the member is not part of the new configuration '%s'", this.partitionId, this.memberId, this.members)));
        }
        for (MemberId member : this.members) {
            boolean memberIsActive;
            boolean bl = memberIsActive = currentClusterConfiguration.hasMember(member) && currentClusterConfiguration.getMember(member).state() == MemberState.State.ACTIVE;
            if (!memberIsActive) {
                return Either.left((Object)new IllegalStateException(String.format("Expected to reconfigure partition '%d' with members '%s', but member '%s' is not active.", this.partitionId, this.members, this.memberId)));
            }
            MemberState memberState = currentClusterConfiguration.getMember(member);
            if (memberState.hasPartition(this.partitionId)) continue;
            return Either.left((Object)new IllegalStateException(String.format("Expected to reconfigure partition '%d' with members '%s', but member '%s' does not have the partition.", this.partitionId, this.members, this.memberId)));
        }
        return Either.right(UnaryOperator.identity());
    }

    @Override
    public ActorFuture<UnaryOperator<ClusterConfiguration>> apply() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.partitionChangeExecutor.forceReconfigure(this.partitionId, this.members).onComplete((ignore, error) -> {
            if (error != null) {
                future.completeExceptionally(error);
            } else {
                future.complete(this::removePartitionFromNonMembers);
            }
        });
        return future;
    }

    private ClusterConfiguration removePartitionFromNonMembers(ClusterConfiguration clusterConfiguration) {
        ClusterConfiguration updatedTopology = clusterConfiguration;
        for (MemberId member : clusterConfiguration.members().keySet()) {
            if (this.members.contains(member) || !clusterConfiguration.getMember(member).hasPartition(this.partitionId)) continue;
            updatedTopology = updatedTopology.updateMember(member, m -> m.removePartition(this.partitionId));
        }
        return updatedTopology;
    }
}

