/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

final class PartitionJoinApplier
implements ConfigurationChangeAppliers.MemberOperationApplier {
    private final int partitionId;
    private final int priority;
    private final PartitionChangeExecutor partitionChangeExecutor;
    private final MemberId localMemberId;
    private Map<MemberId, Integer> partitionMembersWithPriority;
    private DynamicPartitionConfig partitionConfig;

    PartitionJoinApplier(int partitionId, int priority, MemberId localMemberId, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.priority = priority;
        this.localMemberId = localMemberId;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.localMemberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        boolean localMemberIsActive;
        boolean bl = localMemberIsActive = currentClusterConfiguration.hasMember(this.localMemberId) && currentClusterConfiguration.getMember(this.localMemberId).state() == MemberState.State.ACTIVE;
        if (!localMemberIsActive) {
            return Either.left((Object)new IllegalStateException("Expected to join partition, but the local member is not active"));
        }
        boolean partitionHasActiveMember = currentClusterConfiguration.members().values().stream().flatMap(memberState -> memberState.partitions().entrySet().stream().filter(partitionState -> (Integer)partitionState.getKey() == this.partitionId).map(Map.Entry::getValue)).anyMatch(partitionState -> partitionState.state() == PartitionState.State.ACTIVE);
        if (!partitionHasActiveMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to join partition %s, but partition has no active members", this.partitionId)));
        }
        MemberState localMemberState = currentClusterConfiguration.getMember(this.localMemberId);
        boolean partitionExistsInLocalMember = localMemberState.hasPartition(this.partitionId);
        if (partitionExistsInLocalMember && localMemberState.getPartition(this.partitionId).state() != PartitionState.State.JOINING) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to join partition %s, but the local member already has the partition at state %s", new Object[]{this.partitionId, localMemberState.partitions().get(this.partitionId).state()})));
        }
        this.partitionMembersWithPriority = this.collectPriorityByMembers(currentClusterConfiguration);
        if (partitionExistsInLocalMember && localMemberState.getPartition(this.partitionId).state() == PartitionState.State.JOINING) {
            this.partitionConfig = localMemberState.getPartition(this.partitionId).config();
            return Either.right(memberState -> memberState);
        }
        this.partitionConfig = this.getPartitionConfig(currentClusterConfiguration);
        return Either.right(memberState -> memberState.addPartition(this.partitionId, PartitionState.joining(this.priority, this.partitionConfig)));
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.join(this.partitionId, this.partitionMembersWithPriority, this.partitionConfig).onComplete((ignore, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.updatePartition(this.partitionId, PartitionState::toActive));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }

    private DynamicPartitionConfig getPartitionConfig(ClusterConfiguration currentClusterConfiguration) {
        return currentClusterConfiguration.members().values().stream().filter(m -> m.hasPartition(this.partitionId)).map(m -> m.partitions().get(this.partitionId)).findAny().orElseThrow().config();
    }

    private HashMap<MemberId, Integer> collectPriorityByMembers(ClusterConfiguration currentClusterConfiguration) {
        HashMap<MemberId, Integer> priorityMap = new HashMap<MemberId, Integer>();
        currentClusterConfiguration.members().forEach((memberId, memberState) -> {
            if (memberState.partitions().containsKey(this.partitionId)) {
                PartitionState partitionState = memberState.partitions().get(this.partitionId);
                priorityMap.put((MemberId)memberId, partitionState.priority());
            }
        });
        priorityMap.put(this.localMemberId, this.priority);
        return priorityMap;
    }
}

