/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

record PartitionLeaveApplier(int partitionId, MemberId localMemberId, PartitionChangeExecutor partitionChangeExecutor) implements ConfigurationChangeAppliers.MemberOperationApplier
{
    @Override
    public MemberId memberId() {
        return this.localMemberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        boolean partitionIsLeaving;
        if (!currentClusterConfiguration.hasMember(this.localMemberId)) {
            return Either.left((Object)new IllegalStateException("Expected to leave partition, but the local member does not exist in the cluster"));
        }
        boolean partitionExistsInLocalMember = currentClusterConfiguration.getMember(this.localMemberId).hasPartition(this.partitionId);
        if (!partitionExistsInLocalMember) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to leave partition, but the local member does not have the partition %s", this.partitionId)));
        }
        boolean bl = partitionIsLeaving = currentClusterConfiguration.getMember(this.localMemberId).getPartition(this.partitionId).state() == PartitionState.State.LEAVING;
        if (partitionIsLeaving) {
            return Either.right(m -> m);
        }
        long partitionReplicaCount = currentClusterConfiguration.members().values().stream().filter(m -> m.hasPartition(this.partitionId)).count();
        if (partitionReplicaCount <= 1L) {
            return Either.left((Object)new IllegalStateException(String.format("Expected to leave partition, but the partition %s has only one replica", this.partitionId)));
        }
        return Either.right(memberState -> memberState.updatePartition(this.partitionId, PartitionState::toLeaving));
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.leave(this.partitionId).onComplete((ignore, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.removePartition(this.partitionId));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }
}

