/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.metrics;

import io.camunda.zeebe.dynamic.config.state.ClusterChangePlan;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.CompletedChange;
import io.prometheus.client.Counter;
import io.prometheus.client.Enumeration;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.List;

public final class TopologyMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String LABEL_OPERATION = "operation";
    private static final String LABEL_OUTCOME = "outcome";
    private static final Gauge TOPOLOGY_VERSION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("cluster_topology_version")).help("The version of the cluster topology")).register();
    private static final Gauge CHANGE_ID = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("cluster_changes_id")).help("The id of the cluster topology change plan")).register();
    private static final Enumeration CHANGE_STATUS = (Enumeration)((Enumeration.Builder)((Enumeration.Builder)((Enumeration.Builder)Enumeration.build().namespace("zeebe")).name("cluster_changes_status")).help("The state of the current cluster topology")).states(ClusterChangePlan.Status.class).register();
    private static final Gauge CHANGE_VERSION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("cluster_changes_version")).help("The version of the cluster topology change plan")).register();
    private static final Gauge PENDING_OPERATIONS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("cluster_changes_operations_pending")).help("Number of pending changes in the current change plan")).register();
    private static final Gauge COMPLETED_OPERATIONS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("cluster_changes_operations_completed")).help("Number of completed changes in the current change plan")).register();
    private static final Histogram OPERATION_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("cluster_changes_operation_duration")).help("Duration it takes to apply an operation")).labelNames(new String[]{"operation"})).buckets(new double[]{0.1, 1.0, 2.0, 5.0, 10.0, 30.0, 60.0, 120.0, 180.0, 300.0, 600.0}).register();
    private static final Counter OPERATION_ATTEMPTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("cluster_changes_operation_attempts")).help("Number of attempts per operation type")).labelNames(new String[]{"operation", "outcome"})).register();

    public static void updateFromTopology(ClusterConfiguration topology) {
        TOPOLOGY_VERSION.set((double)topology.version());
        CHANGE_STATUS.state((Enum)topology.pendingChanges().map(ClusterChangePlan::status).or(() -> topology.lastChange().map(CompletedChange::status)).orElse(ClusterChangePlan.Status.COMPLETED));
        CHANGE_ID.set((double)topology.pendingChanges().map(ClusterChangePlan::id).orElse(0L).longValue());
        CHANGE_VERSION.set((double)topology.pendingChanges().map(ClusterChangePlan::version).orElse(0).intValue());
        PENDING_OPERATIONS.set((double)topology.pendingChanges().map(ClusterChangePlan::pendingOperations).map(List::size).orElse(0).intValue());
        COMPLETED_OPERATIONS.set((double)topology.pendingChanges().map(ClusterChangePlan::completedOperations).map(List::size).orElse(0).intValue());
    }

    public static OperationObserver observeOperation(ClusterConfigurationChangeOperation operation) {
        return OperationObserver.startOperation(operation);
    }

    public static final class OperationObserver {
        private final ClusterConfigurationChangeOperation operation;
        private final Histogram.Timer timer;

        private OperationObserver(ClusterConfigurationChangeOperation operation, Histogram.Timer timer) {
            this.operation = operation;
            this.timer = timer;
        }

        static OperationObserver startOperation(ClusterConfigurationChangeOperation operation) {
            return new OperationObserver(operation, ((Histogram.Child)OPERATION_DURATION.labels(new String[]{operation.getClass().getSimpleName()})).startTimer());
        }

        public void failed() {
            this.timer.close();
            ((Counter.Child)OPERATION_ATTEMPTS.labels(new String[]{this.operation.getClass().getSimpleName(), "failed"})).inc();
        }

        public void applied() {
            this.timer.close();
            ((Counter.Child)OPERATION_ATTEMPTS.labels(new String[]{this.operation.getClass().getSimpleName(), "applied"})).inc();
        }
    }
}

