/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.state;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.CompletedChange;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public record ClusterChangePlan(long id, int version, Status status, Instant startedAt, List<CompletedOperation> completedOperations, List<ClusterConfigurationChangeOperation> pendingOperations) {
    public static ClusterChangePlan init(long id, List<ClusterConfigurationChangeOperation> operations) {
        return new ClusterChangePlan(id, 1, Status.IN_PROGRESS, Instant.now(), List.of(), List.copyOf(operations));
    }

    ClusterChangePlan advance() {
        List<ClusterConfigurationChangeOperation> nextPendingOperations = List.copyOf(this.pendingOperations.subList(1, this.pendingOperations.size()));
        ArrayList<CompletedOperation> newCompletedOperations = new ArrayList<CompletedOperation>(this.completedOperations);
        newCompletedOperations.add(new CompletedOperation(this.pendingOperations.get(0), Instant.now()));
        return new ClusterChangePlan(this.id, this.version + 1, this.status, this.startedAt(), newCompletedOperations, nextPendingOperations);
    }

    CompletedChange completed() {
        return new CompletedChange(this.id, Status.COMPLETED, this.startedAt(), Instant.now());
    }

    public ClusterChangePlan merge(ClusterChangePlan other) {
        if (other == null) {
            return this;
        }
        if (other.version > this.version) {
            return other;
        }
        return this;
    }

    public boolean hasPendingChangesFor(MemberId memberId) {
        return !this.pendingOperations.isEmpty() && this.pendingOperations.get(0).memberId().equals((Object)memberId);
    }

    public ClusterConfigurationChangeOperation nextPendingOperation() {
        return this.pendingOperations().get(0);
    }

    public boolean hasPendingChanges() {
        return !this.pendingOperations().isEmpty();
    }

    public CompletedChange cancel() {
        return new CompletedChange(this.id, Status.CANCELLED, this.startedAt(), Instant.now());
    }

    public static enum Status {
        IN_PROGRESS,
        COMPLETED,
        FAILED,
        CANCELLED;

    }

    public record CompletedOperation(ClusterConfigurationChangeOperation operation, Instant completedAt) {
    }
}

