/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.state;

import com.google.common.collect.ImmutableMap;
import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.state.ClusterChangePlan;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.CompletedChange;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record ClusterConfiguration(long version, Map<MemberId, MemberState> members, Optional<CompletedChange> lastChange, Optional<ClusterChangePlan> pendingChanges, Optional<RoutingState> routingState) {
    public static final int INITIAL_VERSION = 1;
    private static final int UNINITIALIZED_VERSION = -1;

    public static ClusterConfiguration uninitialized() {
        return new ClusterConfiguration(-1L, Map.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public boolean isUninitialized() {
        return this.version == -1L;
    }

    public static ClusterConfiguration init() {
        return new ClusterConfiguration(1L, Map.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ClusterConfiguration addMember(MemberId memberId, MemberState state) {
        if (this.members.containsKey(memberId)) {
            throw new IllegalStateException(String.format("Expected add a new member, but member %s already exists with state %s", memberId.id(), this.members.get(memberId)));
        }
        ImmutableMap newMembers = ImmutableMap.builder().putAll(this.members).put((Object)memberId, (Object)state).build();
        return new ClusterConfiguration(this.version, (Map<MemberId, MemberState>)newMembers, this.lastChange, this.pendingChanges, this.routingState);
    }

    public ClusterConfiguration updateMember(MemberId memberId, UnaryOperator<MemberState> memberStateUpdater) {
        MemberState updateMemberState;
        MemberState currentState = this.members.get(memberId);
        if (Objects.equals(currentState, updateMemberState = (MemberState)memberStateUpdater.apply(currentState))) {
            return this;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (updateMemberState != null) {
            mapBuilder.putAll(this.members).put((Object)memberId, (Object)updateMemberState);
        } else {
            mapBuilder.putAll(this.members.entrySet().stream().filter(entry -> !((MemberId)entry.getKey()).equals((Object)memberId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        ImmutableMap newMembers = mapBuilder.buildKeepingLast();
        return new ClusterConfiguration(this.version, (Map<MemberId, MemberState>)newMembers, this.lastChange, this.pendingChanges, this.routingState);
    }

    public ClusterConfiguration startConfigurationChange(List<ClusterConfigurationChangeOperation> operations) {
        if (this.hasPendingChanges()) {
            throw new IllegalArgumentException("Expected to start new configuration change, but there is a configuration change in progress " + String.valueOf(this.pendingChanges));
        }
        if (operations.isEmpty()) {
            throw new IllegalArgumentException("Expected to start new configuration change, but there is no operation");
        }
        long newVersion = this.version + 1L;
        return new ClusterConfiguration(newVersion, this.members, this.lastChange, Optional.of(ClusterChangePlan.init(newVersion, operations)), this.routingState);
    }

    public ClusterConfiguration merge(ClusterConfiguration other) {
        if (this.version > other.version) {
            return this;
        }
        if (other.version > this.version) {
            return other;
        }
        Map<MemberId, MemberState> mergedMembers = Stream.concat(this.members.entrySet().stream(), other.members().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, MemberState::merge));
        Optional<ClusterChangePlan> mergedChanges = Stream.of(this.pendingChanges, other.pendingChanges).flatMap(Optional::stream).reduce(ClusterChangePlan::merge);
        Optional<RoutingState> mergedRoutingState = Stream.of(this.routingState, other.routingState).flatMap(Optional::stream).reduce(RoutingState::merge);
        return new ClusterConfiguration(this.version, (Map<MemberId, MemberState>)ImmutableMap.copyOf(mergedMembers), this.lastChange, mergedChanges, mergedRoutingState);
    }

    public boolean hasPendingChanges() {
        return this.pendingChanges.isPresent() && this.pendingChanges.orElseThrow().hasPendingChanges();
    }

    private boolean hasPendingChangesFor(MemberId memberId) {
        return this.pendingChanges.isPresent() && this.pendingChanges.get().hasPendingChangesFor(memberId);
    }

    public Optional<ClusterConfigurationChangeOperation> pendingChangesFor(MemberId memberId) {
        if (!this.hasPendingChangesFor(memberId)) {
            return Optional.empty();
        }
        return Optional.of(this.pendingChanges.orElseThrow().nextPendingOperation());
    }

    public ClusterConfiguration advanceConfigurationChange(UnaryOperator<ClusterConfiguration> configurationUpdater) {
        return ((ClusterConfiguration)configurationUpdater.apply(this)).advance();
    }

    private ClusterConfiguration advance() {
        if (!this.hasPendingChanges()) {
            throw new IllegalStateException("Expected to advance the configuration change, but there is no pending change");
        }
        ClusterConfiguration result = new ClusterConfiguration(this.version, this.members, this.lastChange, Optional.of(this.pendingChanges.orElseThrow().advance()), this.routingState);
        if (!result.hasPendingChanges()) {
            Map<MemberId, MemberState> currentMembers = result.members().entrySet().stream().filter(entry -> ((MemberState)entry.getValue()).state() != MemberState.State.LEFT).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            CompletedChange completedChange = this.pendingChanges.orElseThrow().completed();
            return new ClusterConfiguration(result.version() + 1L, currentMembers, Optional.of(completedChange), Optional.empty(), this.routingState);
        }
        return result;
    }

    public boolean hasMember(MemberId memberId) {
        return this.members().containsKey(memberId);
    }

    public MemberState getMember(MemberId memberId) {
        return this.members().get(memberId);
    }

    public int clusterSize() {
        return (int)this.members.entrySet().stream().filter(entry -> ((MemberState)entry.getValue()).state() != MemberState.State.LEFT && ((MemberState)entry.getValue()).state() != MemberState.State.UNINITIALIZED).count();
    }

    public int partitionCount() {
        return (int)this.members.values().stream().flatMap(m -> m.partitions().keySet().stream()).distinct().count();
    }

    public Integer minReplicationFactor() {
        return this.members.values().stream().filter(entry -> entry.state() != MemberState.State.LEFT && entry.state() != MemberState.State.UNINITIALIZED).flatMap(m -> m.partitions().entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.counting())).values().stream().reduce(Math::min).map(Long::intValue).orElse(0);
    }

    public ClusterConfigurationChangeOperation nextPendingOperation() {
        if (!this.hasPendingChanges()) {
            throw new NoSuchElementException();
        }
        return this.pendingChanges.orElseThrow().nextPendingOperation();
    }

    public ClusterConfiguration cancelPendingChanges() {
        if (this.hasPendingChanges()) {
            CompletedChange cancelledChange = this.pendingChanges.orElseThrow().cancel();
            long newVersion = this.version + 2L;
            return new ClusterConfiguration(newVersion, this.members, Optional.of(cancelledChange), Optional.empty(), this.routingState);
        }
        return this;
    }
}

