/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.state;

import io.atomix.cluster.MemberId;
import java.util.Collection;
import java.util.Optional;

public sealed interface ClusterConfigurationChangeOperation {
    public MemberId memberId();

    public static sealed interface PartitionChangeOperation
    extends ClusterConfigurationChangeOperation {
        public int partitionId();

        public record PartitionBootstrapOperation(MemberId memberId, int partitionId, int priority) implements PartitionChangeOperation
        {
        }

        public record PartitionEnableExporterOperation(MemberId memberId, int partitionId, String exporterId, Optional<String> initializeFrom) implements PartitionChangeOperation
        {
        }

        public record PartitionDisableExporterOperation(MemberId memberId, int partitionId, String exporterId) implements PartitionChangeOperation
        {
        }

        public record PartitionForceReconfigureOperation(MemberId memberId, int partitionId, Collection<MemberId> members) implements PartitionChangeOperation
        {
        }

        public record PartitionReconfigurePriorityOperation(MemberId memberId, int partitionId, int priority) implements PartitionChangeOperation
        {
        }

        public record PartitionLeaveOperation(MemberId memberId, int partitionId) implements PartitionChangeOperation
        {
        }

        public record PartitionJoinOperation(MemberId memberId, int partitionId, int priority) implements PartitionChangeOperation
        {
        }
    }

    public record MemberRemoveOperation(MemberId memberId, MemberId memberToRemove) implements ClusterConfigurationChangeOperation
    {
    }

    public record MemberLeaveOperation(MemberId memberId) implements ClusterConfigurationChangeOperation
    {
    }

    public record MemberJoinOperation(MemberId memberId) implements ClusterConfigurationChangeOperation
    {
    }
}

